%def_disable snapshot
%define api_version 3.0
%define rname gtkmm
%define ver_major 3.24
%def_enable atkmm
%def_disable demos
%def_enable check
%def_enable docs

Name: libgtkmm3
Version: %ver_major.10
Release: alt1

Summary: A C++ interface for GTK3 (a GUI library for X)
License: GPL-2.0 and LGPL-2.1
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

Vcs: https://gitlab.gnome.org/GNOME/gtkmm.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%rname/%ver_major/%rname-%version.tar.xz
%else
Source: %rname-%version.tar
%endif

Provides: %rname = %version

%define mm_ver 0.9.10
%define gtk_ver 3.24.0
%define glib_ver 2.54.0
%define pangomm_ver 2.40.0
%define atkmm_ver 2.24.2
%define cairo_ver 1.12.0

BuildRequires(pre): meson
BuildRequires: gcc-c++ mm-common >= %mm_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libglibmm-devel >= %glib_ver libpangomm-devel >= %pangomm_ver
BuildRequires: libcairomm-devel >= %cairo_ver libepoxy-devel
%{?_enable_atkmm:BuildRequires: libatkmm-devel >= %atkmm_ver}
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz fonts-ttf-open-sans xsltproc}
%{?_enable_check:BuildRequires: xvfb-run}

%description
Gtkmm provides a C++ interface to the GTK+ GUI library. gtkmm2 wraps GTK+ 2.
Highlights include typesafe callbacks, widgets extensible via inheritance
and a comprehensive set of widget classes that can be freely combined to
quickly create complex user interfaces.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C++
Requires: %name = %version-%release
Provides: %rname-devel = %version

%description devel
This package contains the static libraries and header files needed for
developing gtkmm applications.

%package doc
Summary: Documentation for developing with %name
Group: Development/Documentation
BuildArch: noarch

%description doc
This package contains the documentation for
developing gtkmm applications.

%package demos
Summary: Demos for developing programs that will use %name
Group: Development/C++
BuildArch: noarch
Requires: %name-devel = %version-%release

%description demos
The %name-demos package contains source code of demo programs for %name.

%prep
%setup -n %rname-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_disable_atkmm:-Dbuild-atkmm-api=false} \
    %{?_disable_demos:-Dbuild-demos=false} \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
xvfb-run %meson_test

%files
%doc NEWS
%_libdir/*.so.*

%files devel
%_includedir/gdkmm-%api_version
%_includedir/%rname-%api_version
%_libdir/*.so
%_libdir/gdkmm-%api_version
%_libdir/%rname-%api_version
%_pkgconfigdir/*.pc

%if_enabled docs
%files doc
%_datadir/devhelp/books/%rname-%api_version
%_docdir/%rname-%api_version
%endif

%if_enabled demos
%files demos
%_datadir/%rname-%api_version
%endif

%changelog
