%def_disable snapshot

%define _name gtk
%define ver_major 4.20
%define api_ver_major 4
%define api_ver %api_ver_major.0
%define binary_ver 4.0.0
%define rdn_name org.gtk.gtk4
%define _libexecdir %_prefix/libexec

%def_enable x11
%def_disable static
%def_enable man
%def_enable introspection
%def_enable gtk_doc
%def_enable colord
# wayland gdk backend
%def_enable wayland
# broadway (HTML5) gdk backend
%def_enable broadway
%def_enable cloudproviders
# 4.8.0: tracker disabled by default
%def_disable tracker
# enabled by default since 4.13.5
# since 4.16.0 -- default renderer on Wayland
%def_enable vulkan
# media backends
# gstreamer enabled by default
%def_enable gstreamer
# droped in 4.13.7
%def_disable ffmpeg
%def_enable cups
%def_disable accesskit

%def_disable sysprof
%def_enable tests
# fatal: posix_spawn: Resource temporarily unavailable on basalt
%def_disable testsuite
# File box-packing.ltr.nodes does not exist
%def_disable install_tests
%def_disable check

Name: lib%_name%api_ver_major
Version: %ver_major.2
Release: alt1

Summary: The GIMP ToolKit (GTK)
Group: System/Libraries
License: LGPL-2.0-or-later
Url: http://www.gtk.org

Vcs: https://gitlab.gnome.org/GNOME/gtk.git

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%endif
Source5: gtk4-icon-cache.filetrigger
Patch: gtk+-2.16.5-alt-stop-spam.patch
# backported from main
Patch10: gtk-4.12.3-alt-printdialog-papersize.patch

%define meson_ver 1.5.0
%define glib_ver 2.82
%define gi_ver 1.84
%define cairo_ver 1.18.2
%define pango_ver 1.56.0
%define atk_ver 2.15.1
%define pixbuf_ver 2.30.0
%define fontconfig_ver 2.2.1-alt2
%define gtk_doc_ver 1.32.1
%define colord_ver 0.1.9
%define cups_ver 2.0
%define wayland_ver 1.24
%define wayland_protocols_ver 1.44
%define xkbcommon_ver 0.2.0
%define epoxy_ver 1.4
%define graphene_ver 1.10
%define cloudproviders_ver 0.2.5
%define rsvg_ver 2.52.0
%define vulkan_ver 1.3
%define harfbuzz_ver 8.4.0
%define gst_ver 1.24
%define accesskit_api_ver 0.15

Requires: gtk4-update-icon-cache = %EVR
Requires: at-spi2-core
Requires: icon-theme-adwaita
Requires: iso-codes
Requires: librsvg >= %rsvg_ver

%{?_enable_colord:Requires: colord}

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson >= %meson_ver gcc-c++ sassc
BuildRequires: glib2-devel >= %glib_ver libgio-devel
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: libcairo-gobject-devel >= %cairo_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libatk-devel >= %atk_ver
BuildRequires: libgdk-pixbuf-devel >= %pixbuf_ver
BuildRequires: libtiff-devel libjpeg-devel
BuildRequires: fontconfig-devel >= %fontconfig_ver
BuildRequires: libepoxy-devel >= %epoxy_ver
BuildRequires: libgraphene-devel >= %graphene_ver
BuildRequires: iso-codes-devel
BuildRequires: libfribidi-devel
BuildRequires: docbook-utils zlib-devel
BuildRequires: pkgconfig(libdrm)
BuildRequires: bash-completion
%if_enabled x11
BuildRequires: libXdamage-devel libX11-devel libXcursor-devel
BuildRequires: libXext-devel libXfixes-devel libXi-devel libXinerama-devel libXrandr-devel
BuildRequires: libXrender-devel libXt-devel
%endif
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: python3-module-docutils}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver libpango-gir-devel libatk-gir-devel >= %atk_ver libgdk-pixbuf-gir-devel libgraphene-gir-devel}
%{?_enable_colord:BuildRequires: libcolord-devel >= %colord_ver}
%{?_enable_wayland:BuildRequires: libwayland-client-devel >= %wayland_ver libwayland-cursor-devel libEGL-devel libwayland-egl-devel libxkbcommon-devel >= %xkbcommon_ver wayland-protocols >= %wayland_protocols_ver}
%{?_enable_cloudproviders:BuildRequires: libcloudproviders-devel >= %cloudproviders_ver}
%{?_enable_tracker:BuildRequires: tracker3-devel}
%{?_enable_vulkan:BuildRequires: /usr/bin/glslc vulkan-devel >= %vulkan_ver}
%{?_enable_cups:BuildRequires: libcups-devel >= %cups_ver}
%{?_enable_accesskit:BuildRequires: pkgconfig(accesskit-c-%accesskit_api_ver)}
# for examples
BuildRequires: libcanberra-gtk3-devel libharfbuzz-devel >= %harfbuzz_ver python3-module-pygobject3
%{?_enable_sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_tests:BuildRequires: librsvg-devel >= %rsvg_ver}
%{?_enable_check:BuildRequires: /proc dbus-tools-gui icon-theme-hicolor gnome-icon-theme-symbolic}
# since 3.94.0 for media backends
%{?_enable_gstreamer:BuildRequires: pkgconfig(gstreamer-player-1.0) >= %gst_ver}
%{?_enable_ffmpeg:
BuildRequires: libavfilter-devel libavformat-devel libavdevice-devel
BuildRequires: libavcodec-devel libavutil-devel libswscale-devel libswresample-devel}

%description
GTK is a multi-platform toolkit for creating graphical user interfaces.
Offering a complete set of widgets, GTK is suitable for projects
ranging from small one-off projects to complete application suites.

This package provides GTK%api_ver_major shared libraries.

%package devel
Summary: Development files and tools for GTK%api_ver_major applications
Group: Development/C
Requires: %name = %EVR
Requires: gtk-builder-convert

%description devel
This package contains development files for GTK%api_ver_major. Use this to
build programs that use GTK%api_ver_major.

%package -n gtk4-update-icon-cache
Summary: Icon theme caching utility for GTK
Group: System/Libraries
# last release of gtk-update-icon-cache is 3.24.32
Obsoletes: gtk-update-icon-cache < %version
Provides: gtk-update-icon-cache = %EVR

%description -n gtk4-update-icon-cache
gtk-update-icon-cache creates mmap()able cache files for icon themes.
GTK can use the cache files created by gtk-update-icon-cache to avoid
a lot of system call and disk seek overhead when the application starts.

%package -n gtk4-demo
Summary: GTK+ widgets demonstration program
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description -n gtk4-demo
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains a program, along with its source code, that
demonstrates GTK%api_ver_major variety of all its widgets.

%package -n %name-devel-doc
Summary: Development documentation for GTK%api_ver_major
Group: Development/Documentation
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description -n %name-devel-doc
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains documentation needed for developing GTK+ applications.

%package -n %name-devel-doc-examples
Summary: Examples for developing applications which will use GTK%api_ver_major
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description -n %name-devel-doc-examples
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains sources for example programs.

%package -n %name-devel-static
Summary: Static libraries for GTK+ (GIMP ToolKit) applications
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description -n %name-devel-static
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains the static libraries for GTK%api_ver_major.

%package gir
Summary: GObject introspection data for the GTK+ library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GTK%api_ver_major library

%package gir-devel
Summary: GObject introspection devel data for the GTK%api_ver_major library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the GTK+ library

This package contains development documentation for GAIL.

%package tests
Summary: Tests for the GTK%api_ver_major packages
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed GTK+3 packages.


%define fulllibpath %_libdir/gtk-%api_ver/%binary_ver

%prep
%setup -n %_name-%version
%patch -p1

%build
%ifarch %e2k
%add_optflags -mno-sse4.2
%endif

%meson \
    %{subst_enable_meson_bool x11 x11-backend} \
    %{subst_enable_meson_bool wayland wayland-backend} \
    %{subst_enable_meson_bool broadway broadway-backend} \
    %{subst_enable_meson_feature cloudproviders cloudproviders} \
    %{subst_enable_meson_feature tracker tracker} \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_bool gtk_doc documentation} \
    %{subst_enable_meson_bool man man-pages} \
    %{subst_enable_meson_feature colord colord} \
    %{subst_enable_meson_feature sysprof sysprof} \
    %{subst_enable_meson_bool tests build-tests} \
    %{subst_enable_meson_bool testsuite build-testsuite} \
    %{subst_enable_meson_feature vulkan vulkan} \
    %{subst_enable_meson_feature gstreamer media-gstreamer} \
    %{subst_enable_meson_feature cups print-cups} \
    %{subst_enable_meson_feature accesskit accesskit}
%nil
%meson_build

%install
%meson_install
install -d %buildroot{%_sysconfdir/gtk-%api_ver,%_libdir/gtk-%api_ver/%binary_ver/engines}

# posttransfiletrigger for update icons cache
install -pD -m755 {%_sourcedir,%buildroot%_rpmlibdir}/gtk4-icon-cache.filetrigger
# backward compatibility symlink
ln -s gtk4-update-icon-cache %buildroot%_bindir/gtk-update-icon-cache

# The license
ln -sf %_licensedir/LGPL-2.0-or-later COPYING

%find_lang --output=gtk40.lang gtk40 gtk40-properties

bzip2 -9kf NEWS

mkdir %buildroot%_libdir/gtk-%api_ver/modules

# examples
mkdir -p %buildroot/%_docdir/%name-devel-%version/examples
cp -r examples/* %buildroot/%_docdir/%name-devel-%version/examples/

%check
%__meson_test

%files -f gtk40.lang
%{?_enable_broadway:%_bindir/gtk4-broadwayd}
%_bindir/gtk4-query-settings
%_bindir/gtk4-launch
%_bindir/gtk4-encode-symbolic-svg
%_libdir/libgtk-4.so.*
%dir %_libdir/gtk-%api_ver/modules
%dir %fulllibpath
%dir %fulllibpath/engines
%{?_enable_ffmpeg:%fulllibpath/media/libmedia-ffmpeg.so}
%dir %_datadir/gtk-%api_ver/
%_datadir/gtk-%api_ver/emoji/
%dir %_sysconfdir/gtk-%api_ver
%if_enabled man
%{?_enable_broadway:%_man1dir/gtk4-broadwayd.1.*}
%_man1dir/gtk4-query-settings.1.*
%_man1dir/gtk4-launch.*
%_man1dir/gtk4-encode-symbolic-svg.1.*
%endif

%_datadir/glib-2.0/schemas/%rdn_name.Settings.ColorChooser.gschema.xml
%_datadir/glib-2.0/schemas/%rdn_name.Settings.Debug.gschema.xml
%_datadir/glib-2.0/schemas/%rdn_name.Settings.EmojiChooser.gschema.xml
%_datadir/glib-2.0/schemas/%rdn_name.Settings.FileChooser.gschema.xml
%_datadir/glib-2.0/schemas/%rdn_name.Inspector.gschema.xml

%doc --no-dereference COPYING
%doc AUTHORS NEWS.bz2 README.md

%files devel
%_bindir/gtk4-builder-tool
%_bindir/gtk4-image-tool
%_bindir/gtk4-path-tool
%_bindir/gtk4-rendernode-tool
%_includedir/gtk-%api_ver/
%_libdir/libgtk-%api_ver_major.so
%_pkgconfigdir/gtk%api_ver_major.pc
%_pkgconfigdir/gtk%api_ver_major-x11.pc
%_pkgconfigdir/gtk%api_ver_major-unix-print.pc
%_pkgconfigdir/gtk%api_ver_major-atspi.pc
%_datadir/gtk-%api_ver/gtk%{api_ver_major}builder.rng
%_datadir/gettext/its/gtk%{api_ver_major}builder.its
%_datadir/gettext/its/gtk%{api_ver_major}builder.loc
%_datadir/gtk-%api_ver/valgrind/
%{?_enable_man:%_man1dir/gtk%{api_ver_major}-builder-tool.1*
%_man1dir/gtk4-image-tool.1*
%_man1dir/gtk4-path-tool.1*
%_man1dir/gtk4-rendernode-tool.1*}
%_datadir/bash-completion/completions/gtk4-builder-tool
%_datadir/bash-completion/completions/gtk4-image-tool
%_datadir/bash-completion/completions/gtk4-path-tool
%_datadir/bash-completion/completions/gtk4-rendernode-tool

%if_enabled wayland
%_pkgconfigdir/gtk%api_ver_major-wayland.pc
%endif

%if_enabled broadway
%_pkgconfigdir/gtk%api_ver_major-broadway.pc
%endif

%files -n gtk4-update-icon-cache
%_bindir/gtk4-update-icon-cache
# compatibility symlink
%_bindir/gtk-update-icon-cache
%_man1dir/gtk4-update-icon-cache*
%_rpmlibdir/gtk4-icon-cache.filetrigger

%files -n gtk4-demo
%_desktopdir/org.gtk.Demo4.desktop
%_desktopdir/%rdn_name.NodeEditor.desktop
%_desktopdir/org.gtk.WidgetFactory4.desktop
%_desktopdir/org.gtk.PrintEditor4.desktop
%_bindir/gtk4-demo
%_bindir/gtk4-demo-application
%_bindir/gtk4-widget-factory
%_bindir/gtk4-node-editor
%_bindir/gtk4-print-editor
%_datadir/glib-2.0/schemas/org.gtk.Demo4.gschema.xml
%_iconsdir/hicolor/scalable/apps/org.gtk.Demo4.svg
#%_iconsdir/hicolor/scalable/apps/org.gtk.IconBrowser4.svg
%_iconsdir/hicolor/scalable/apps/org.gtk.PrintEditor4*.svg
%_iconsdir/hicolor/scalable/apps/org.gtk.WidgetFactory4.svg
%_iconsdir/hicolor/symbolic/apps/org.gtk.Demo4-symbolic.svg
#%_iconsdir/hicolor/symbolic/apps/org.gtk.IconBrowser4-symbolic.svg
%_iconsdir/hicolor/symbolic/apps/org.gtk.PrintEditor4-symbolic.svg
%_iconsdir/hicolor/symbolic/apps/org.gtk.WidgetFactory4-symbolic.svg
%_iconsdir/hicolor/*/*/%rdn_name.NodeEditor*.svg

%_datadir/metainfo/org.gtk.Demo4.appdata.xml
%_datadir/metainfo/org.gtk.PrintEditor4.appdata.xml
%_datadir/metainfo/org.gtk.WidgetFactory4.appdata.xml
%_datadir/metainfo/%rdn_name.NodeEditor.appdata.xml

%if_enabled man
%_man1dir/gtk4-demo.1.*
%_man1dir/gtk4-demo-application.1.*
%_man1dir/gtk4-widget-factory.1.*
%_man1dir/gtk4-node-editor.1*
%endif

%_datadir/bash-completion/completions/gtk4-demo
%_datadir/bash-completion/completions/gtk4-node-editor
%_datadir/bash-completion/completions/gtk4-print-editor
%_datadir/bash-completion/completions/gtk4-widget-factory

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/gdk4/
%_datadir/doc/gdk4-wayland/
%_datadir/doc/gdk4-x11/
%_datadir/doc/gsk4/
%_datadir/doc/gtk4/
%endif

%files devel-doc-examples
%doc %_docdir/%name-devel-%version/examples

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%fulllibpath/*/*.a
%endif

%if_enabled introspection
%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*
%endif

%if_enabled install_tests
%files tests
%_libexecdir/installed-tests/gtk-%api_ver/
%_datadir/installed-tests/gtk-%api_ver/
%endif


%changelog
