%define ver_major 1.14
%define api_ver 1
%define namespace Gsf
%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_enable check
# valgrind tests failed for aarch64, ppc64le and armh
%ifarch %ix86 x86_64
%def_enable valgrind
%endif

Name: libgsf
Version: %ver_major.53
Release: alt1

Summary: GNOME Structured file library
License: GPL-2.0 and LGPL-2.1
Group: System/Libraries
Url: http://www.gnumeric.org/

Vcs: https://gitlab.gnome.org/GNOME/libgsf.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildRequires(pre): rpm-build-gir

# From configure.ac
BuildRequires: gtk-doc >= 1.0
BuildRequires: libgio-devel >= 2.26.0
BuildRequires: libxml2-devel >= 2.4.16
BuildRequires: libgdk-pixbuf-devel bzlib-devel zlib-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_static:BuildRequires: glibc-devel-static}
%{?_enable_check:
%{?_enable_valgrind:BuildRequires(pre): rpm-macros-valgrind
%ifarch %valgrind_arches
BuildRequires: valgrind
%endif}
BuildRequires: perl-XML-Parser unzip}

%description
GNOME Structured file library

%package devel
Summary: Libraries and include files for gsf
Group: Development/C
Requires: %name = %EVR

%description devel
This package provides the necessary development libraries and include
files to allow you to develop programs using gsf.

%package gir
Summary: GObject introspection data for the gsf library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GNOME Structured file library.

%package gir-devel
Summary: GObject introspection devel data for the gsf library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the GNOME Structured file library.

%package devel-doc
Summary: Development documentation for gsf
Group: Development/C
BuildArch: noarch
Conflicts: %name-gnome < %version

%description devel-doc
This package contains the documentation for development programs using gsf.

%package devel-static
Summary: Static gsf libraries
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
This package provides the necessary development libraries to allow you
to build programs staticallly linked against libgsf.

%setup_python_module gsf
%package -n python-module-gsf
Summary: Python bindings for %name
Group: Development/Python
Autoreq: yes
Requires: %name = %EVR
%add_python_req_skip _gsf

%description -n python-module-gsf
This package contains files that are needed to use libgsf from Python
programs.

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup
subst 's/pythondir/pyexecdir/' python/Makefile.am

%build
%autoreconf
%configure \
    --with-gdk-pixbuf \
    --with-bz2 \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{?_enable_introspection:--enable-introspection=yes} \
    %{subst_enable static}
%nil
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%check
%make check

%files -f %name.lang
%_bindir/*
%_libdir/%name-%api_ver.so.*
%_datadir/thumbnailers/gsf-office.thumbnailer
%_man1dir/*
%doc AUTHORS README TODO NEWS

%files devel
%dir %_includedir/%name-%api_ver
%dir %_includedir/%name-%api_ver/gsf
%_includedir/%name-%api_ver/gsf/*.h
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%if_enabled static
%files devel-static
%_libdir/%name-%api_ver.a
%endif

%if_enabled gtk_doc
%files devel-doc
%_gtk_docdir/*
%endif

%changelog
