%def_disable snapshot
%def_enable docs
%def_enable check

%define _name granite
%define rdn_name io.elementary.%_name-%api_ver_major
%define ver_major 7.7
%define namespace Granite
%define api_ver_major 7
%define api_ver 7.0
%define sover 7

Name: lib%_name%api_ver_major
Version: %ver_major.0
Release: alt1

Summary: Extension of GTK4 libraries
Group: System/Libraries
License: LGPL-3.0-or-later
Url: https://github.com/elementary/%_name

Vcs: https://github.com/elementary/granite.git

%if_disabled snapshot
Source: %url/archive/%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.50
%define gtk4_ver 4.12
%define vala_ver 0.40

Requires: elementary-icon-theme >= 7.3

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson sassc
BuildRequires: vala-tools >= %vala_ver libgio-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk4_ver
BuildRequires: libgee0.8-devel gobject-introspection-devel
BuildRequires: libgtk4-gir-devel libgee0.8-gir-devel
BuildRequires: pkgconfig(shumate-1.0)
%{?_enable_docs:BuildRequires: gtk-doc valadoc}

%description
Granite is a companion library for GTK4 and GLib that provides complex
widgets and convenience methods designed for use in apps built for
elementary OS.

This package contains the shared library.

%package devel
Summary: Extension of GTK+ libraries (development files)
Group: Development/GNOME and GTK+
Requires: %name = %EVR
Provides: %name-vala = %EVR

%description devel
Granite is a companion library for GTK4 and GLib that provides complex
widgets and convenience methods designed for use in apps built for
elementary OS.

This package contains header files.

%package -n %_name%api_ver_major-demo
Summary: Extension of GTK4 libraries (demo binary)
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description -n %_name%api_ver_major-demo
Granite is a companion library for GTK4 and GLib that provides complex
widgets and convenience methods designed for use in apps built for
elementary OS.

This package contains a small demo application to show Granite Widgets.

%package gir
Summary: GObject introspection data for the Granite library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Granite library.

%package gir-devel
Summary: GObject introspection devel data for the Granite library.
Group: System/Libraries
BuildArch: noarch
Requires: %name-devel = %EVR
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the Granite library.

%prep
%setup -n %_name-%version

%build
%meson %{subst_enable_meson_bool docs documentation}
%meson_build

%install
%meson_install
%find_lang %_name-%api_ver_major

%check
%__meson_test

%files -f %_name-%api_ver_major.lang
%_libdir/*.so.%{sover}*
%_iconsdir/hicolor/*/*/*.svg
%_datadir/themes/%namespace/
%_datadir/metainfo/%_name-%api_ver_major.metainfo.xml
%doc README*

%files devel
%_includedir/%_name-%api_ver_major/
%_libdir/*.so
%_pkgconfigdir/%_name-%api_ver_major.pc
%_datadir/vala/vapi/%_name-%api_ver_major.deps
%_datadir/vala/vapi/%_name-%api_ver_major.vapi

%files -n %_name%api_ver_major-demo
%_bindir/*
%_desktopdir/%rdn_name.demo.desktop

%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir


%changelog
