%define MOUNT_DIR /media

%def_disable pygobject

Name: libgpod4
Version: 0.8.3
Release: alt9

Summary: iPod access library
Group: Sound
License: LGPLv3+
Url: http://www.gtkpod.org/libgpod

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch1: %name-0.8.3-alt-swig.patch
Patch2: %name-0.8.3-alt-libplist-2.0.patch
# fc
Patch3: libgpod-0.8.3-implicit-int.patch
Patch4: libgpod-0.8.3-no-plist_dict_insert_item.patch

Provides: libgpod = %version-%release
Obsoletes: libgpod < 0.7

BuildRequires: gcc-c++ gtk-doc intltool
BuildRequires: glib2-devel libgio-devel libsqlite3-devel
BuildRequires: libimobiledevice-devel >= 1.3.0 libplist-devel >= 2.2.0
BuildRequires: libxml2-devel libsgutils-devel libusb-devel zlib-devel
BuildRequires: libtag-devel libgdk-pixbuf-devel
%{?_enable_pygobject:BuildRequires: python-module-pygobject-devel python-module-mutagen swig}
BuildRequires: rpm-build-licenses
%if 0
BuildRequires: /proc mono-devel libgtk-sharp2-devel
%endif

%description
libgpod is a library meant to abstract access to an iPod content. It
provides an easy to use API to retrieve the list of files and playlist
stored on an iPod, to modify them and to save them back to the iPod.

%package -n libgpod-devel
Summary: Development files for libgpod
Group: Development/C
Requires: %name = %version-%release

%description -n libgpod-devel
Files needed to develop applications that use libgpod,
an iPod access library.

%package -n libgpod-devel-doc
Summary: Development documentation for libgpod
Group: Development/C
BuildArch: noarch

%description -n libgpod-devel-doc
API documentation in gtk-doc format for libgpod,
an iPod access library.

%package -n python-module-gpod
Summary: Python bindings for libgpod
Group: Development/Python
Requires: %name = %version-%release
Obsoletes: python-modules-gpod < %version-%release
Provides: python-modules-gpod = %version-%release

%description -n python-module-gpod
Python bindings for libgpod, an iPod access library.

%package -n libgpod-sharp
Summary: C#/.NET library to access iPod content
Group: Development/Other
Requires: %name = %version-%release

%description -n libgpod-sharp
C#/.NET library to access iPod content.  Provides bindings to the libgpod
library.


%package -n libgpod-sharp-devel
Summary: Development files for libgpod-sharp
Group: Development/Other
Requires: libgpod-sharp = %version-%release

%description -n libgpod-sharp-devel
C#/.NET library to access iPod content.  Provides bindings to the libgpod
library.

This package contains the files required to develop programs that will use
libgpod-sharp.

%prep
%setup
%patch -p1
%patch1
%patch2 -p1
%patch3 -p1
%patch4 -p1

# remove execute perms on the python examples as they'll be installed in %%doc
chmod -x bindings/python/examples/*.py

%build
%add_optflags %(getconf LFS_CFLAGS)
%add_optflags -Wno-error=incompatible-pointer-types -Wno-error=implicit-int -Wno-deprecated-declarations
%autoreconf
%configure \
	--disable-static \
	--enable-gtk-doc \
	%{subst_enable pygobject} \
	--without-hal \
	--without-mono \
	--enable-udev \
	--with-libimobiledevice \
	--with-temp_mount_dir="%MOUNT_DIR" \
	--enable-more-warnings=no

%make_build
pushd bindings/python
make README
popd

%install
%makeinstall_std

# remove Makefiles from the python examples dir
rm -rf bindings/python/examples/Makefile*

rm -f %buildroot%python_sitelibdir/gpod/*.la
rm -f %buildroot%_pkgconfigdir/libgpod-sharp.pc

%find_lang libgpod

%files -f libgpod.lang
%_bindir/*
%_libdir/*.so.*
/lib/udev/rules.d/*
/lib/udev/*-set-info

%files -n libgpod-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/libgpod-1.0.pc

%files -n libgpod-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled pygobject
%files -n python-module-gpod
%doc COPYING bindings/python/README bindings/python/examples
%python_sitelibdir/gpod
%endif

%if 0
%files -n libgpod-sharp
%_libdir/libgpod

%files -n libgpod-sharp-devel
%_pkgconfigdir/libgpod-sharp.pc
%endif

%changelog
