%define sover 6
%define sover_port 12
%def_disable static

Name: libgphoto2
Version: 2.5.33
Release: alt1

Group: System/Libraries
Summary: Library to access to digital cameras
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
Url: http://www.gphoto.org/
Vcs: https://github.com/gphoto/libgphoto2.git
License: LGPLv2+
Packager: Dmitriy Khanzhin <jinn@altlinux.org>

# Automatically added by buildreq on Mon Nov 04 2024
BuildRequires: doxygen gcc-c++ libcurl-devel libexif-devel libgd3-devel libjpeg-devel
BuildRequires: liblockdev-devel libltdl7-devel libusb-devel libxml2-devel

# IMHO, this build requires are needs when build with cdk
#BuildRequires: libncurses-devel libtinfo-devel

# Url for source code downloads now http://sourceforge.net/project/showfiles.php?group_id=8874
Source0: %name-%version.tar
Patch0: %name-2.5.30-alt-translation.patch

%description
This library contains all the functionality to access to modern digital
cameras via USB or the serial port.

%package -n %name-%sover
Group: System/Libraries
Summary: Library to access to digital cameras
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
License: LGPLv2+
Requires: %name-common = %EVR
Provides: %name = %EVR
Obsoletes: %name < %EVR

%description -n %name-%sover
The %name library can be used by applications to access various digital
camera models, via standard protocols such as USB Mass Storage and PTP,
or vendor-specific protocols.
This package contains the library.

%package -n %{name}_port-%sover_port
Group: System/Libraries
Summary: Library to access to digital camera ports
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
License: LGPLv2+

%description -n %{name}_port-%sover_port
The %name library can be used by applications to access various digital
camera models, via standard protocols such as USB Mass Storage and PTP,
or vendor-specific protocols.
This package contains the runtime code for port access.

%package common
Group: System/Libraries
Summary: Common files for %name
Summary (ru_RU.UTF-8): Общие файлы для библиотеки libgphoto2
License: LGPLv2+
BuildArch: noarch

%description common
Common files for %name.

%package -n %name-devel
Group: Development/C
Summary: Headers and links to compile against the %name library
Summary (ru_RU.UTF-8): Заголовочные и другие файлы для компиляции приложений с библиотекой libgphoto2
License: LGPLv2+
Requires: %name-%sover = %EVR

%description -n %name-devel
This package contains all files which one needs to compile programs using
the %name library.

%package -n %name-devel-doc
Group: Development/Other
Summary: Development documentation of the %name library
Summary (ru_RU.UTF-8): Документация для разработчиков библиотеки libgphoto2
License: LGPLv2+
BuildArch: noarch
Requires: %name-common = %EVR

%description -n %name-devel-doc
This package contains development documentation of the %name library.

%if_enabled static
%package -n %name-devel-static
Group: Development/C
Summary: Static versions of %name
Summary (ru_RU.UTF-8): Статические версии библиотек libgphoto2
License: LGPLv2+
Requires: %name-devel = %EVR

%description -n %name-devel-static
This package contains libraries which one needs to compile programs statically linked
against %name library.
%endif

##### TRANSLATED DESCRIPTIONS  #####

%description -l ru_RU.UTF-8
Библиотека предоставляет все необходимые функции для обмена данными
с современными цифровыми фотокамерами посредством USB или последовательного порта.

%description -n %name-%sover -l ru_RU.UTF-8
Библиотека libgphoto2 используется приложениями для доступа к различным моделям
цифровых камер, посредством стандартных протоколов, таких как USB-накопитель
и PTP, или специфических протоколов производителей.
Этот пакет ссодержит собственно библиотеку.

%description -n %{name}_port-%sover_port -l ru_RU.UTF-8
Библиотека libgphoto2 используется приложениями для доступа к различным моделям
цифровых камер, посредством стандартных протоколов, таких как USB-накопитель
и PTP, или специфических протоколов производителей.
Этот пакет ссодержит исполняемый код для доступа к портам.

%description common -l ru_RU.UTF-8
Общие файлы для библиотеки libgphoto2.

%description -n %name-devel -l ru_RU.UTF-8
Пакет содержит все необходимые файлы для компиляции программ, использующих
библиотеку libgphoto2.

%description -n %name-devel-doc -l ru_RU.UTF-8
Пакет содержит документацию для разработчиков библиотеки libgphoto2.

%if_enabled static
%description -n %name-devel-static  -l ru_RU.UTF-8
Пакет содержит статические версии библиотек для компиляции программ, использующих
библиотеку libgphoto2.
%endif

%prep
%setup -n %name-%version
%patch0 -p1

%build
sed -i '/driverdir/d' libgphoto2_port/libgphoto2_port.pc.in
%autoreconf
export udevscriptdir=%_udevdir
export utilsdir=%_libexecdir/%name
%configure \
    %{subst_enable static} \
    --with-drivers=all \
    --disable-rpath
%make_build

%install
%makeinstall_std

# create udev support
export LD_LIBRARY_PATH=%buildroot%_libdir
export CAMLIBS=%buildroot%_libdir/%name/%version
mkdir -p %buildroot%_udevrulesdir
%buildroot%_libexecdir/%name/print-camera-list --verbose udev-rules version 201 owner root mode 0660 group camera > %buildroot%_udevrulesdir/40-%name.rules 2> /dev/null
mkdir -p %buildroot%_udevhwdbdir
%buildroot%_libexecdir/%name/print-camera-list hwdb > %buildroot%_udevhwdbdir/20-%name.hwdb 2> /dev/null

# remove unneded print-camera-list
rm -f %buildroot%_libexecdir/%name/print-camera-list
# remove circular symlink in /usr/include/gphoto2
rm -f %buildroot%_includedir/gphoto2/gphoto2
# udev helper not used now
rm -f %buildroot%_udevdir/check-ptp-camera
# remove .la files
rm -f %buildroot%_libdir/%name/*/*.la
rm -f %buildroot%_libdir/%{name}_port/*/*.la
# correct content of doc. directory
rm -rf %buildroot/%_datadir/doc/%name/{linux-hotplug,ABOUT-NLS,COPYING,ChangeLog,RELEASE-HOWTO.md}
cp OUTDATED.txt %buildroot/%_datadir/doc/%name/

%find_lang --output=%name.lang %name-%sover
%find_lang --append --output=%name.lang %{name}_port-%sover_port

##### PRE/POST INSTALL SCRIPTS #####

%pre common
# create group
groupadd -fr camera || :

%triggerpostun -- %name <= 2.4.0
ldconfig

##### FILE LISTS FOR ALL BINARY PACKAGES #####

%files -n %name-%sover
%_libdir/%name.so.*
%dir %_libdir/%name
%dir %_libdir/%name/*
%_libdir/%name/*/*.so

%files -n %{name}_port-%sover_port
%_libdir/%{name}_port.so.*
%dir %_libdir/%{name}_port
%dir %_libdir/%{name}_port/*
%_libdir/%{name}_port/*/*.so

%files common -f %name.lang
%_udevrulesdir/*
%_udevhwdbdir/*
%dir %_datadir/%name
%_datadir/%name/*
%dir %_datadir/%{name}_port
%_datadir/%{name}_port/*
%dir %_datadir/doc/%name
%_datadir/doc/%name/AUTHORS
%_datadir/doc/%name/NEWS
%_datadir/doc/%name/README.md
%_datadir/doc/%name/OUTDATED.txt
%dir %_datadir/doc/%{name}_port
%_datadir/doc/%{name}_port/*

%files -n %name-devel
%_bindir/*-config
%_includedir/gphoto2
%_libdir/*.so
%_libdir/pkgconfig/*
%_man3dir/%{name}*

%files -n %name-devel-doc
%_datadir/doc/%name/*
%exclude %_datadir/doc/%name/AUTHORS
%exclude %_datadir/doc/%name/NEWS
%exclude %_datadir/doc/%name/README.md
%exclude %_datadir/doc/%name/OUTDATED.txt

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%_libdir/%name/*/*.a
%_libdir/%{name}_port/*/*.a
%endif

%changelog
