%define oname gnet
%define ver_major 2.0
%def_disable static

Name: lib%oname
Version: %ver_major.8
Release: alt4.1

Summary: GNet is a simple network library
License: LGPL
Group: System/Libraries
URL: http://www.gnetlibrary.org/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>
Source: %gnome_ftp/%oname/%ver_major/%oname-%version.tar.bz2
Source1: %name-%ver_major.map
Patch1: %name-%version-alt-versioning.patch
Patch2: libgnet-fix-move_define.patch
Patch3: libgnet-2.0.8-alt-DSO.patch

BuildRequires: rpm-build-gnome
BuildRequires: gtk-doc libcheck-devel
BuildRequires: glib2-devel >= 2.6.0
BuildRequires: gcc-c++ 


%description
GNet is a simple network library.  It is written in C,
object-oriented, and built upon GLib.  It is intended to be easy to
use and port.  GNet comes with documentation and examples.  It is
licensed under the GNU Library General Public Licence.

Features:
  * TCP "client" and "server" sockets
  * UDP and IP Multicast sockets
  * High-level TCP connection and server objects
  * Asynchronous socket IO
  * Internet address abstraction
  * Asynchronous DNS lookup
  * IPv4 and IPv6 support
  * Byte packing and unpacking
  * URI parsing
  * SHA and MD5 hashes
  * Base64 encoding and decoding
  * SOCKS support
  * High-level HTTP connection object

%package devel
Summary: Header files for the Gnet library
Group: Development/C
Requires: %name = %version-%release

%description devel
Gnet is a simple network library. It is writen in C, object-oriented,
and built upon glib.
This package allows you to develop applications that use the Gnet library.


%if_enabled static
%package devel-static
Summary: Static Gnet library
Group: Development/C
Requires: %name-devel = %version-%release glib2-devel-static

%description devel-static
Gnet is a simple network library. It is writen in C, object-oriented,
and built upon glib.
This package allows you to develop statically linked applications that
use the Gnet library.

%endif


%prep
%setup -q -n %oname-%version
%patch1 -p1
%patch2 -p1
%patch3 -p2
install -p -m644 %SOURCE1 src/libgnet-2.0.map

%build
%autoreconf
%configure   \
	     %{subst_enable static} \
	      --with-html-dir=%_docdir
%make_build

%install
%make_install DESTDIR=%buildroot install

%make -C examples clean
rm -f examples/Makefile*
rm -Rf examples/.deps/
rm -Rf %buildroot%_docdir

%files
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_libdir/gnet-2.0
%_pkgconfigdir/*
%_includedir/*
%_datadir/aclocal/*
%doc AUTHORS ChangeLog HACKING NEWS README TODO doc/html examples

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
