Name: libglfw3
Version: 3.4
Release: alt2

Summary: A cross-platform multimedia library
License: Zlib
Group: System/Libraries

Url: http://www.glfw.org/index.html
Vcs: https://github.com/glfw/glfw.git
Source: https://github.com/glfw/glfw/archive/%version/%version.tar.gz

Obsoletes: libglfw = 3.0.2

BuildRequires(pre): rpm-macros-cmake
# Automatically added by buildreq on Wed Oct 16 2013
# optimized out: cmake-modules libGL-devel libICE-devel libSM-devel libX11-devel libXau-devel libXext-devel libXfixes-devel libXi-devel libXrender-devel libXt-devel xorg-fixesproto-devel xorg-inputproto-devel xorg-kbproto-devel xorg-randrproto-devel xorg-renderproto-devel xorg-xf86miscproto-devel xorg-xf86vidmodeproto-devel xorg-xproto-devel
BuildRequires: cmake doxygen glibc-devel-static libGLU-devel libXScrnSaver-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXft-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXres-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libxkbfile-devel libxkbcommon-devel
BuildRequires: libvulkan-devel
BuildRequires: libwayland-client-devel libwayland-cursor-devel libwayland-server-devel wayland-devel
BuildRequires: pkgconfig(wayland-egl)

%description
GLFW is a free, Open Source, multi-platform library for OpenGL
application development that provides a powerful API for handling
operating system specific tasks such as opening an OpenGL window,
reading keyboard, mouse, joystick and time input, creating threads, and
more.

%package devel
Summary: Support for developing C application
Requires: %name =  %version-%release
Group: Development/C
Obsoletes: libglfw-deevel = 3.0.2
Provides: libglfw-devel = %version
Provides: glfw-devel = %version
#Requires: xorg-x11-proto-devel

%description devel
The glfw-devel package contains header files for developing glfw
applications.

%prep
%setup -n glfw-%version
find . -type f | xargs sed -i 's/\r//'

%ifarch %e2k
# somehow breaks cmake
sed -i 's/C_STANDARD 99//;1i set(CMAKE_C_STANDARD 99)' {tests,examples}/CMakeLists.txt
%endif

%build
%cmake -DBUILD_SHARED_LIBS:BOOL=ON
%cmake_build --target all

%install
%cmake_install

%files
%doc README.md
%_libdir/libglfw.so.*

%files devel
%_includedir/GLFW
%_libdir/*.so
%_libdir/pkgconfig/*.pc
%_libdir/cmake/glfw3/*.cmake

%changelog
