%define _name girara
%define _soname 4
%define _unpackaged_files_terminate_build 1

%if %{expand:%%{!?_without_check:%%{!?_disable_check:1}}0}
%def_enable tests
%else
%def_disable tests
%endif

Name: lib%_name
Version: 0.4.5
Release: alt1

Summary: GTK-based minimalistic user interface library
License: Zlib
Group: System/Libraries
URL: https://pwmt.org/projects/girara
Vcs: https://github.com/pwmt/girara.git
Source: %name-%version.tar

Patch: %name-%version-%release.patch

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1

BuildRequires: libgtk+3-devel >= 3.4 libpango-devel
%{?_enable_tests:BuildRequires: xvfb-run}
%{?_enable_vala:BuildRequires: vala-tools}

%description
girara is a library that implements a user interface that focuses on
simplicity and minimalism.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: libgtk+3-devel

%description devel
This package contains libraries and header files for
developing applications that use %name.

%prep
%setup
%patch -p1

%build
%meson \
	-Djson=disabled \
	%{subst_enable_meson_feature tests tests}

%meson_build -v

%install
%meson_install
%find_lang %name-gtk3-%_soname

%check
%meson_test

%files -f %name-gtk3-%_soname.lang
%doc AUTHORS README.md LICENSE
%_libdir/*.so.%_soname
%_libdir/*.so.%_soname.*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%changelog
