Name: libgif
Version: 4.1.6
Release: alt4

Summary: A library for manipulating GIF format image files
Group: System/Libraries
License: MIT
Url: http://sourceforge.net/projects/giflib/

# http://downloads.sourceforge.net/giflib/giflib-%version.tar.bz2
Source: giflib-%version.tar
Patch1: libgif-4.1.6-alt-tmp.patch
Patch2: libgif-4.1.6-alt-fixes.patch
Patch3: libgif-4.1.6-alt-vers.patch
Patch4: libgif-4.1.6-deb-cve.patch
Patch5: libgif-4.1.6-deb-doc-fixes.patch
Patch6: libgif-4.1.6-deb-spelling-fixes.patch
Patch7: libgif-4.1.6-alt-include-header-stdlib.patch

%def_disable static

Provides: libungif = %version-%release
Obsoletes: libungif < %version-%release

%package devel
Summary: Development tools for programs which will use the %name library
Group: Development/C
Requires: %name = %version-%release
Provides: libungif-devel = %version-%release
Obsoletes: libungif-devel < %version-%release

%package devel-static
Summary: Static %name library
Group: Development/C
Requires: %name-devel = %version-%release
Provides: libungif-devel-static = %version-%release
Obsoletes: libungif-devel-static < %version-%release

%package utils
Summary: Programs for manipulating GIF format image files
Group: Graphics
Requires: %name = %version-%release
Provides: libungif-progs = %version-%release
Obsoletes: libungif-progs < %version-%release

%description
This package contains a shared library of functions for loading and
saving GIF format image files.  The %name library can load any GIF file,
but it will save GIFs only in uncompressed format (i.e., it won't use
the patented LZW compression used to save "normal" compressed GIF files).

%description devel
This package contains development files and documentation necessary for
development of programs that will use the %name library to load and save
GIF format image files.

%description devel-static
This package contains static %name library necessary for development of
statically linked programs that will use the %name library to load and
save GIF format image files.

%description utils
This package contains various programs for manipulating GIF format
image files.

%prep
%setup -n giflib-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
# fix format warnings
sed -i 's/fprintf(stderr, VersionStr)/fprintf(stderr, "%%s", VersionStr)/' util/*.c
bzip2 -9fk ChangeLog

%build
%autoreconf
%configure %{subst_enable static} --disable-x11
%make_build
s="$(readelf -d lib/.libs/libgif.so.%version |
	sed -n 's/.*(SONAME).*\[[^.]\+\(.\+\)\].*/\1/p')"
echo '{ local: *; };' >libungif.vers
%__cc %optflags -shared -Wl,-soname,libungif$s,--version-script,libungif.vers,-no-as-needed \
	-Llib/.libs -lgif -o libungif.so.%version

%install
%makeinstall_std
install -pm644 libungif.so.%version %buildroot%_libdir/
ln -s libgif.so %buildroot%_libdir/libungif.so

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 AUTHORS BUGS ChangeLog.bz2 \
	COPYING DEVELOPERS NEWS ONEWS README TODO \
	doc/*.{png,html,txt} util/{giffiltr,gifspnge}.c \
	%buildroot%docdir/

%files
%_libdir/*.so.*
%dir %docdir
%docdir/[A-Z][A-Z]*
%docdir/*.bz2

%files utils
%_bindir/*
%dir %docdir
%docdir/*.html
%docdir/*.png

%files devel
%_libdir/*.so
%_includedir/*
%dir %docdir
%docdir/*.c
%docdir/*.txt

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
