%def_disable snapshot

%define _name gdk-pixbuf
%define api_ver 2.0
%define binary_ver 2.10.0
%define ver_major 2.44
%define _libexecdir %_prefix/libexec
# timeout multiplier for tests
%define timeout 2

# glycin is a deafult loader
%def_disable glycin
# since 2.42.11 others -- ani, bmp, icns, ico, pnm, qtif, tga, xbm, xpm
%def_enable others
%def_enable doc
%def_enable man
%def_enable introspection
%def_enable thumbnailer
%def_enable installed_tests
%def_enable check

Name: lib%_name
Version: %ver_major.4
Release: alt1

Summary: An image loading and rendering library for Gdk
Group: System/Libraries
License: LGPL-2.1
Url: https://www.gtk.org

Vcs: https://gitlab.gnome.org/GNOME/gdk-pixbuf.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
Patch: %_name-2.37.92-alt-compat-version-script.patch

Source1: %_name.map
Source2: %_name.lds

%define meson_ver 1.5
%define glib_ver 2.56.0
%define gi_ver 0.9.5
%define glycin_api_ver 2
%define glycin_ver 2.0.1

%{?_enable_glycin:Requires: glycin-%glycin_api_ver-loaders >= %glycin_ver bubblewrap}
Requires: %name-locales = %EVR
Requires: shared-mime-info

Provides: %name-loaders = %version
Obsoletes: %name-loaders <= %version

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson >= %meson_ver
BuildRequires: /proc libgio-devel >= %glib_ver
BuildRequires: pkgconfig(shared-mime-info)
%{?_disable_glycin:BuildRequires: libjpeg-devel libpng-devel libtiff-devel}
%{?_enable_glycin:BuildRequires: pkgconfig(glycin-%glycin_api_ver) >= %glycin_ver}
%{?_enable_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: /usr/bin/rst2man}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
%{?_enable_check:%{?_enable_glycin:BuildRequires: bubblewrap}}

%description
The GdkPixBuf library provides a number of features:
+ Image loading facilities.
+ Rendering of a GdkPixBuf into various formats:
  drawables (windows, pixmaps), GdkRGB buffers.

%package locales
Summary: Internationalization for GdkPixBuf library
Group: System/Internationalization
Conflicts: %name < %version-%release
BuildArch: noarch

%description locales
This package provides internationalization support for GdkPixBuf,
an image loading and rendering library for Gdk.

%package devel
Summary: Development files for GdkPixBuf applications
Group: Development/C
Requires: %name = %EVR

%description devel
GdkPixBuf is an image loading and rendering library for Gdk.

This package provides include files needed for developing GdkPixBuf
applications.

%package devel-doc
Summary: Development documentation for GdkPixBuf library
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
GdkPixBuf is an image loading and rendering library for Gdk.

This package provides documentation needed for developing GdkPixBuf
applications.

%package gir
Summary: GObject introspection data for the GdkPixBuf library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GdkPixBuf library

%package gir-devel
Summary: GObject introspection devel data for the GdkPixBuf library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the GdkPixBuf library

%package tests
Summary: Tests for the GdkPixBuf library
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed GdkPixBuf library.

%prep
%setup -n %_name-%version
%patch -p1 -b .alt

install -p -m644 %_sourcedir/%_name.map %_name/compat.map
install -p -m644 %_sourcedir/%_name.lds %_name/compat.lds

%build
%ifarch %e2k
# till lcc ~1.23
export LIBS=-lcxa
%endif
%meson \
    %{subst_enable_meson_bool doc documentation} \
    %{subst_enable_meson_bool man man} \
    %{subst_enable_meson_feature introspection introspection} \
    %{subst_enable_meson_bool installed_tests installed_tests} \
    %{subst_enable_meson_feature glycin glycin} \
    %{subst_enable_meson_feature others others} \
    %{subst_enable_meson_feature thumbnailer thumbnailer}
%nil
%meson_build

%install
%meson_install
ln %buildroot%_bindir/%_name-query-loaders %buildroot%_libdir/%_name-%api_ver/%binary_ver/

# rpm posttrans filetriggers
mkdir -p %buildroot%_rpmlibdir
cat > %buildroot%_rpmlibdir/gdk-pixbuf-loaders.filetrigger << '@@@'
#!/bin/sh -efu

LC_ALL=C sed -rn 's|(^/usr/lib(64)?)/gdk-pixbuf.*/loaders/.*|\1|p' | sort -u | while read L; do
       if [ -x "$L/%_name-%api_ver/%binary_ver/%_name-query-loaders" ]; then
              $L/%_name-%api_ver/%binary_ver/%_name-query-loaders --update-cache
       fi
done
@@@
chmod 755 %buildroot%_rpmlibdir/gdk-pixbuf-loaders.filetrigger
touch %buildroot%_libdir/%_name-%api_ver/%binary_ver/loaders.cache


%find_lang %_name

%check
%__meson_test -t %timeout

%files
%_bindir/gdk-pixbuf-query-loaders
%{?_enable_thumbnailer:%_bindir/gdk-pixbuf-thumbnailer}
%_libdir/libgdk_pixbuf-%api_ver.so.*
%dir %_libdir/%_name-%api_ver
%dir %_libdir/%_name-%api_ver/%binary_ver
%dir %_libdir/%_name-%api_ver/%binary_ver/loaders
%_libdir/%_name-%api_ver/%binary_ver/%_name-query-loaders
%{?_enable_others:
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-ani.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-bmp.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-icns.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-ico.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-pnm.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-qtif.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-tga.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-xbm.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-xpm.so}
%{?_disable_glycin:
# builtin by default: jpeg, png
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-gif.so
%_libdir/%_name-%api_ver/%binary_ver/loaders/libpixbufloader-tiff.so}
%{?_enable_thumbnailer:%_datadir/thumbnailers/gdk-pixbuf-thumbnailer.thumbnailer}
%{?_enable_man:%_man1dir/gdk-pixbuf-query-loaders*}
%ghost %_libdir/%_name-%api_ver/%binary_ver/loaders.cache
%_rpmlibdir/gdk-pixbuf-loaders.filetrigger

%files locales -f %_name.lang

%files devel
%_bindir/gdk-pixbuf-csource
%_bindir/%_name-pixdata
%_libdir/*.so
%dir %_includedir/%_name-%api_ver
%_includedir/%_name-%api_ver/%_name
%_pkgconfigdir/%_name-%api_ver.pc
%{?_enable_man:%_man1dir/gdk-pixbuf-csource*}
%doc NEWS README.md

%if_enabled doc
%files devel-doc
%_datadir/doc/%_name
%_datadir/doc/gdk-pixdata
%endif

%if_enabled introspection
%files gir
%_typelibdir/GdkPixbuf-%api_ver.typelib
%_typelibdir/GdkPixdata-%api_ver.typelib

%files gir-devel
%_girdir/GdkPixbuf-%api_ver.gir
%_girdir/GdkPixdata-%api_ver.gir
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name/
%_datadir/installed-tests/%_name/
%endif


%changelog
