%define _unpackaged_files_terminate_build 1

%def_disable static
%def_without pango
%define cairo system

Name: libgdiplus
Version: 6.2
Release: alt1

Summary: An Open Source implementation of the GDI+ API
License: MIT
Group: System/Libraries
Url: https://gitlab.winehq.org/mono/libgdiplus.git
VCS: https://gitlab.winehq.org/mono/libgdiplus.git

Source: %name-%version.tar

BuildRequires: fontconfig-devel
BuildRequires: gcc-c++
BuildRequires: glib2-devel
BuildRequires: libX11-devel
BuildRequires: libXrender-devel
BuildRequires: libcairo-devel
BuildRequires: libexif-devel
BuildRequires: libfreetype-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: libtiff-devel
BuildRequires: libungif-devel
BuildRequires: zlib-devel
%{?_with_pango:BuildRequires: libpango-devel}

%description
An Open Source implementation of the GDI+ API.

%package devel
Summary: Development libraries and headers for %name
Group: Development/C
Requires: %name = %EVR

%description devel
Libraries and header files for developing against libgdiplus.

%prep
%setup
# disable downloading submodule
echo '' > update_submodules.sh

%build
NOCONFIGURE=1 ./autogen.sh --skip-cairo
%configure  \
%if %cairo == system
	--with-cairo=%cairo \
	%{?_with_pango:--with-pango} \
%endif
	%{subst_enable static}

%make_build

%install
%makeinstall_std

%files
%_libdir/*.so.*

%files devel
%_pkgconfigdir/*.pc
%_libdir/*.so

%changelog
