%def_disable snapshot
%define _libexecdir %_prefix/libexec

%define _name gdata
%define ver_major 0.18
%define api_ver 0.0

%def_enable gnome
%def_enable goa
%def_enable introspection
%def_enable vala
%def_enable gtk_doc
%def_enable installed_tests
%def_disable check

Name: lib%_name
Version: %ver_major.1
Release: alt2

Summary: Library for the GData protocol
Group: System/Libraries
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/libgdata

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch: %name-0.18.1-fc-gcr-4.patch

%define glib_ver 2.44
%define soup_ver 2.42
%define goa_ver 3.8
%define uhttpmock_ver 0.5.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gtk-doc
BuildRequires: glib2-devel >= %glib_ver libgdk-pixbuf-devel libgtk+3-devel
BuildRequires: libjson-glib-devel libuhttpmock-devel >= %uhttpmock_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libjson-glib-gir-devel libuhttpmock-gir-devel}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_gnome:BuildRequires: gcr4-libs-devel libxml2-devel libsoup-gnome-devel >= %soup_ver libsoup-gnome-gir-devel}
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver libgnome-online-accounts-gir-devel}

%description
libgdata is a GLib-based library for accessing online service APIs using the
GData protocol --- most notably, Google's services. It provides APIs to access
the common Google services, and has full asynchronous support.

%package gir
Summary: GObject introspection data for the GData library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the GData library.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development documentation for the %name
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
libgdata is a GLib-based library for accessing online service APIs using the
GData protocol --- most notably, Google's services. It provides APIs to access
the common Google services, and has full asynchronous support.

This package contains development documentation for the %name.

%package gir-devel
Summary: GObject introspection devel data for the GData library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the GData library.

%package tests
Summary: Tests for %name
Group: Development/Other

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %name.

%prep
%setup
%patch -p1

%build
%meson \
	%{?_disable_gnome:-Dgnome=false} \
	%{?_disable_goa-Dgoa=false} \
	%{?_enable_gtk_doc:-Dgtk_doc=true} \
	%{?_disable_vala:-Dvapi=false} \
	%{?_enable_installed_tests:-Dinstalled_tests=true}
%meson_build

%install
%meson_install
%find_lang %_name

%check
%__meson_test

%files -f %_name.lang
%_libdir/*.so.*
%doc NEWS README AUTHORS

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/%name.pc
%{?_enable_vala:%_vapidir/%name.*}

%if_enabled introspection
%files gir
%_typelibdir/GData-%api_ver.typelib

%files gir-devel
%_girdir/GData-%api_ver.gir
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name/
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%name/
%_datadir/installed-tests/%name/
%endif


%changelog
