Name: libgcrypt
Version: 1.10.2
Release: alt2

Group: System/Libraries
Summary: The GNU crypto library
License: GPL-2.0-or-later AND LGPL-2.1-or-later AND GPL-3.0-or-later
Url: http://www.gnupg.org/

Source: %name-%version.tar

Patch0: 0001-Fix-LFS-on-32-bit-systems.patch
Patch1: 0002-Remove-unknown-suffix-from-version.patch

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%ifarch armh
%define optflags_lto %nil
%endif

%set_verify_elf_method strict

%define soversion 20
%define soname %name%soversion

BuildRequires: pkgconfig(gpg-error)
BuildRequires: makeinfo

%description
Libgcrypt is a general purpose cryptographic library
based on the code from GNU Privacy Guard.

%package -n %soname
Summary: The GNU crypto library
Group: System/Libraries
Provides: %name = %version-%release

%description -n %soname
Libgcrypt is a general purpose cryptographic library
based on the code from GNU Privacy Guard.

%package -n gcrypt-utils
Group: Networking/Other
Summary: Utilities for the %name package
Conflicts: %name-devel <= 1.4.2
Provides: %name-utils = %version-%release
Obsoletes: %name-utils < %version-%release

%description -n gcrypt-utils
This package contains %name utilities.

%package devel
Group: Development/Other
Summary: Development files for the %name package
Requires: %soname = %version-%release
Conflicts: %{name}0-devel

%description devel
Libgcrypt is a general purpose cryptographic library
based on the code from GNU Privacy Guard.
This package contains files needed to develop
applications using libgcrypt (e.g. Aegypten project).

%prep
%setup
%autopatch -p1

cat > doc/version.texi <<EOF
@set UPDATED $(LANG=C date -u -r doc/gcrypt.texi +'%%d %%B %%Y')
@set UPDATED-MONTH $(LANG=C date -u -r doc/gcrypt.texi +'%%B %%Y')
@set EDITION %version
@set VERSION %version
EOF

%build
%autoreconf

%configure \
    --enable-shared \
    --enable-noexecstack \
    --enable-ld-version-script \
    --enable-random=linux \
    --disable-dev-random \
    --disable-doc

%ifarch armh
sed -i -e '/ HAVE_COMPATIBLE_GCC_ARM_PLATFORM_AS /d' config.h
%endif

%make_build
%make_build -C doc hmac256.1 gcrypt.info

%install
%makeinstall_std

install -D -m0644 doc/gcrypt.info %buildroot%_infodir/gcrypt.info
install -D -m0644 doc/hmac256.1 %buildroot%_man1dir/hmac256.1

# relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/libgcrypt.so; do
        t=$(readlink -v "$f")
        ln -rsnf %buildroot/%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%check
%ifnarch aarch64
%make check
%endif

%files -n gcrypt-utils
%_bindir/dumpsexp
%_bindir/hmac256
%_bindir/mpicalc
%_man1dir/hmac256.*

%files -n %soname
/%_lib/%name.so.*
%doc AUTHORS NEWS README

%files devel
%_bindir/*-config
%_includedir/*
%_libdir/*.so
%_aclocaldir/*
%_pkgconfigdir/*.pc
%_infodir/*.info*

%changelog
