%def_disable snapshot
%define _name freeglut
%define sover 3
%def_enable replace_glut
%def_disable wayland
%def_disable check

%define glut_version 5:8.0.1
%define glut_release alt3

Name: lib%_name
Version: 3.6.0
Release: alt1

Summary: A freely licensed alternative to the GLUT library
License: MIT
Group: System/Libraries
Url: http://%_name.sourceforge.net/

%if_disabled snapshot
Source: http://download.sourceforge.net/%_name/%_name-%version.tar.gz
%else
Vcs: https://github.com/dcnieho/FreeGLUT.git
Source: %_name-%version.tar
%endif
Patch1: libfreeglut-3.4.0-alt-fix-visibility-hidden.patch
Patch2: libfreeglut-alt-enable-visibility-hidden.patch

Provides: libglut = %version %_name = %version
Obsoletes: libglut < %version %_name < %version

Obsoletes: libGLUT <= %glut_version-%glut_release
Provides: libGLUT = %glut_version-alt4
Conflicts: libmesaglut

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ninja-build gcc-c++ ctest libGLU-devel libXcomposite-devel libXcursor-devel libXdamage-devel
BuildRequires: libXdmcp-devel libXft-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel
BuildRequires: libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libxkbfile-devel
%{?_enable_wayland:BuildRequires: libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel libEGL-devel libxkbcommon-devel}

%description
%_name is a completely open source alternative to the OpenGL Utility Toolkit
(GLUT) library with an OSI approved free software license. GLUT was originally
written by Mark Kilgard to support the sample programs in the second edition
OpenGL 'RedBook'. Since then, GLUT has been used in a wide variety of practical
applications because it is simple, universally available and highly portable.

%_name allows the user to create and manage windows containing OpenGL
contexts on a wide range of platforms and also read the mouse, keyboard and
joystick functions.

%package devel
Summary: Freeglut developmental libraries and header files
Group: Development/C
Requires: %name = %EVR
# due to freeglut_std.h
Requires: libGL-devel libGLU-devel
Obsoletes: libGLUT-devel <= %glut_version-%glut_release
Provides: libGLUT-devel = %glut_version-alt4
Conflicts: libmesaglut-devel
Provides: libglut-devel = %version %_name-devel = %version
Obsoletes: libglut-devel < %version %_name-devel < %version

%description devel
Developmental libraries and header files required for developing or compiling
software which links to the freeglut library, which is an open source
alternative to the popular GLUT library, with an OSI approved free software
license.

%prep
%setup -n %_name-%version
%patch1 -p3
%patch2 -p3

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
       -G Ninja \
       -DCMAKE_BUILD_TYPE="Release" \
       -DFREEGLUT_BUILD_STATIC_LIBS:BOOL=OFF \
       %{?_enable_replace_glut:-DFREEGLUT_REPLACE_GLUT:BOOL=ON} \
       %{?_disable_replace_glut:-DFREEGLUT_REPLACE_GLUT:BOOL=OFF} \
       %{?_enable_wayland:-DFREEGLUT_WAYLAND=ON}
%nil
%cmake_build

%install
%cmake_install
# always install glut.h and freeglut.pc
install -m644 include/GL/glut.h %buildroot%_includedir/GL
ln -s glut.pc %buildroot%_pkgconfigdir/%_name.pc
%if_disabled replace_glut
# compatibility symlinks
ln -s %_name.pc %buildroot%_pkgconfigdir/glut.pc
ln -s lib%_name.so %buildroot%_libdir/libglut.so
%endif

%check
%cmake_build -t test

%files
%if_enabled replace_glut
%_libdir/libglut.so.*
%else
%_libdir/lib%_name.so.*
%endif

%files devel
%_includedir/GL/*.h
%if_enabled replace_glut
%_libdir/libglut.so
%_pkgconfigdir/%_name.pc
%_pkgconfigdir/glut.pc
%else
%_libdir/lib%_name.so
%_libdir/libglut.so
%_pkgconfigdir/%_name.pc
%_pkgconfigdir/glut.pc
%endif
%_libdir/cmake/FreeGLUT/

%changelog
