%define sover 4
%define gtkver 3

%def_disable bootstrap

Name: libfm
Version: 1.4.0
Release: alt1

Summary: Core library of PCManFM file manager
License: GPL-2.0-or-later
Group: System/Libraries

Url: https://github.com/lxde/libfm
VCS: https://github.com/lxde/libfm.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%{?_disable_bootstrap:BuildPreReq: rpm-build-xdg}
BuildRequires: intltool %{?_disable_bootstrap:libmenu-cache-devel}
BuildRequires: libdbus-glib-devel libudisks2-devel
BuildRequires: glib2-devel libgtk+%gtkver-devel
BuildRequires: gtk-doc
BuildRequires: vala >= 0.13.0
BuildRequires: libexif-devel
BuildRequires: libxslt-devel

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake

%description
LibFM is a core library of PCManFM file manager.

%package -n %name%sover
Summary: %summary
Group: System/Libraries
Requires: gvfs wm-common-freedesktop
Conflicts: libfm2

%description -n %name%sover
LibFM is a core library of PCManFM file manager.

It is developed as the core of next generation PCManFM and takes care
of all file-related operations such as copy & paste, drag & drop, file
associations or thumbnail support. By utilizing glib/gio and gvfs
libfm can access remote filesystems supported by gvfs.

%package devel
Summary: Development files for %name
Group: Development/Other
Conflicts: libfm2-devel

%description devel
This package contains files needed to build applications using LibFM.

%if_disabled bootstrap
%package -n lxde-lxshortcut
Summary: Application shortcuts editor
Group: Graphical desktop/Other

%description -n lxde-lxshortcut
LXShortcut is a small program used to edit application shortcuts
created with freedesktop.org Desktop Entry spec.
%endif

%prep
%setup
sed -ri '/AM_INIT_AUTOMAKE/s,-Werror,\0 -Wno-portability,' configure.ac

%build
%autoreconf
%configure \
    --disable-static \
    --disable-silent-rules \
%if_disabled bootstrap
    --with-gtk=%gtkver \
%else
    --with-extra-only \
    --with-gtk=no \
%endif
    --disable-gtk-doc \
    --enable-largefile \
    --enable-udisks \
    --sysconfdir=%_sysconfdir

%make_build

# FIXME: tilda versions don't work with RPM in general
sed -i 's,\~[a-z0-9]*,,g' libfm*.pc

%install
%makeinstall_std
%find_lang libfm

# Remove unnecessary files
rm -f %buildroot%_libdir/%name/modules/*.la
%if %gtkver==3
    rm -f %buildroot%_pkgconfigdir/libfm-gtk.pc
%endif
%if %gtkver==2
    rm -f %buildroot%_pkgconfigdir/libfm-gtk3.pc
%endif

%files -n %name%sover -f libfm.lang
%_libdir/*.so.%sover
%_libdir/*.so.%sover.*
%if_disabled bootstrap
%_xdgconfigdir/*
%dir %_libdir/%name
%dir %_libdir/%name/modules
%_libdir/%name/modules/*.so
%_xdgmimedir/packages/*
%_datadir/%name/
%_desktopdir/libfm-pref-apps.desktop
%_bindir/libfm-pref-apps
%_man1dir/libfm-pref-apps.1*
%endif

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*
#%%doc %_datadir/gtk-doc/html/%name

%if_disabled bootstrap
%files -n lxde-lxshortcut
%_bindir/lxshortcut
%_desktopdir/lxshortcut.desktop
%_man1dir/lxshortcut.1*
%endif

%changelog
