Name: libfaketime
Version: 0.9.10
Release: alt3

Summary: Manipulate system time per process for testing purposes
License: GPLv2+
Group: Development/C

Url: https://github.com/wolfcw/libfaketime
# Source-url: https://github.com/wolfcw/libfaketime/archive/refs/tags/v%version.tar.gz
Source: libfaketime-%version.tar
Patch: libfaketime-symver.patch

#Provides: faketime
Conflicts: faketime

BuildRequires: perl-Time-HiRes
BuildRequires: libuthash-devel >= 2.0.2

%description
libfaketime intercepts various system calls which programs use to
retrieve the current date and time. It can then report faked dates and
times (as specified by you, the user) to these programs. This means you
can modify the system time a program sees without having to change the
time system- wide.

%prep
%setup
%patch -p1
# use external uthash.h from libuthash-devel
rm -v src/uthash.h

%build
cd src

# https://github.com/wolfcw/libfaketime/blob/master/README.packagers
# Upstream libfaketime requires a mess of different compile time flags
# for different glibc versions and architectures.
# https://github.com/wolfcw/libfaketime/pull/178
# Goal is to build time autodetect these with autotools in the next release ...

# TODO: see rpm-build-features
FAKETIME_COMPILE_CFLAGS="BOGUS"

# for reasons we don't know the old glibc workaround is required here
# but not on archv7hl and aarch64 ...
%ifarch %ix86 x86_64
    echo "force_monotonic"
    export FAKETIME_COMPILE_CFLAGS="-DFORCE_MONOTONIC_FIX"
%endif
%ifarch ppc64le
    echo "force_monotonic and pthread_nonver"
    export FAKETIME_COMPILE_CFLAGS="-DFORCE_MONOTONIC_FIX -DFORCE_PTHREAD_NONVER"
%endif
%ifarch armh aarch64 %e2k riscv64
    unset FAKETIME_COMPILE_CFLAGS
%endif
%ifarch loongarch64
    echo "force_pthread_nonver"
    export FAKETIME_COMPILE_CFLAGS="-DFORCE_PTHREAD_NONVER"
%endif

if [ "$FAKETIME_COMPILE_CFLAGS" == "BOGUS" ]; then
  echo "SHOULD NEVER REACH HERE ... YOU HAVE AN UNTESTED VERSION+ARCH, see rpm spec for details ... ABORT"
  exit 1
fi

%ifarch %e2k
# still needed as of lcc 1.26.21
%add_optflags -Wno-error=attributes
%endif

export CFLAGS="%optflags -Wno-nonnull-compare -Wno-strict-aliasing"
%make_build PREFIX="%prefix" LIBDIRNAME="/%_lib/faketime" all

%check
%ifnarch armh %ix86 mipsel
%make_build -C test
%endif

%install
%makeinstall_std PREFIX="%prefix" LIBDIRNAME="/%_lib/faketime"
rm -r %buildroot/%_docdir/faketime
# needed for stripping/debug package
#chmod a+rx %buildroot/%_libdir/faketime/*.so.*

%files
%doc COPYING
%doc README NEWS README.developers
%_bindir/faketime
%dir %_libdir/faketime/
%_libdir/faketime/libfaketime*so.*
%_man1dir/*

%changelog
