#
# spec file for package libevt
#
# Copyright (c) 2013 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

Name: libevt
Version: 20240421
Release: alt1

Summary: Library and tools to access the Windows Event Log (EVT) format
License: LGPLv3+ and GFDLv1.3+
Group: File tools

Url: https://github.com/libyal/libevt
#DL-URL: https://github.com/libyal/libevt/releases/download/20240421/libevt-alpha-20240421.tar.gz
Source: %name-alpha-%version.tar.gz
Source1: Windows_Event_Log_(EVT).pdf
Source2: %name.watch

# Some dependencies are missing on excluded architectures
ExcludeArch: %arm aarch64

BuildRequires: pkg-config
BuildRequires: python3-dev
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: pkgconfig(libbfio) >= 20120426
BuildRequires: pkgconfig(libcdata) >= 20120425
BuildRequires: pkgconfig(libcfile) >= 20120526
BuildRequires: pkgconfig(libclocale) >= 20120425
BuildRequires: pkgconfig(libcnotify) >= 20120425
BuildRequires: pkgconfig(libcpath) >= 20120701
BuildRequires: pkgconfig(libcsplit) >= 20120701
BuildRequires: pkgconfig(libcthreads) >= 20130723
BuildRequires: pkgconfig(libfdatetime) >= 20120522
BuildRequires: pkgconfig(libfguid) >= 20120426
BuildRequires: pkgconfig(libregf) >= 20120405
BuildRequires: pkgconfig(libuna) >= 20120425
BuildRequires: pkgconfig(libwrc) >= 20120405
# build fails with version in factory, use internal version
#verified 10/13/2013
BuildRequires: pkgconfig(libcerror) >= 20130904
# not released as a package by upstream
#BuildRequires:  pkgconfig(libcstring) >= 20120425
#BuildRequires:  pkgconfig(libcsystem) >= 20120425
#BuildRequires:  pkgconfig(libcdirectory) >= 20120423
#BuildRequires:  pkgconfig(libfwnt) >= 20120426
#BuildRequires:  pkgconfig(libfwevt) >= 20120426
#BuildRequires:  pkgconfig(libfvalue) >= 20120428
#BuildRequires:  pkgconfig(libfdata) >= 20120405
#BuildRequires:  pkgconfig(libfcache) >= 20120405
#BuildRequires:  pkgconfig(libexe) >= 20120405

%description
libevt is a library and tools to access the Windows Event Log
(EVT) format.

For the Windows XML Event Log (EVTX) format, see libevtx.

%package tools
Summary: Utilities to export events from Windows Event Log files
License: LGPLv3+
Group: File tools

%description tools
Tools for reading Windows Event Log (EVT) files. These include
evtinfo and evtexport. See evtxtools for Windows XML Event Log (EVTX)
programs.

%package devel
Summary: Development files for libevt, a Windows event file parser
License: LGPLv3+ and GFDLv1.3+
Group: Development/C
Requires: %name = %version

%description devel
libevt is a library to access the Windows Event Log (EVT) format.

This subpackage contains libraries and header files for developing
applications that want to make use of %name.

%package -n python3-module-%name
Summary: Python bindings for libevt, a Windows event file parser
License: LGPLv3+
Group: Development/Python

%description -n python3-module-%name
Python bindings for libevt, which can read Windows event files.

%prep
%setup
cp -a "%SOURCE1" .

%build
%configure \
	--disable-static \
	--enable-wide-character-type \
	--enable-python \
	--with-pythondir=%python3_sitelibdir
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog README
%_libdir/libevt.so.*

%files tools
%_bindir/evt*
%_man1dir/evt*.1*

%files devel
%doc AUTHORS ChangeLog README Windows_Event_Log*.pdf
%_includedir/*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*

%files -n python3-module-%name
%doc AUTHORS ChangeLog README
%python3_sitelibdir/pyevt.so
%python3_sitelibdir/pyevt.la

%changelog
