Name: libetpan
Version: 1.9.4
Release: alt6

Summary: This mail library  provide a portable, efficient middleware for different kinds of mail access
License: BSD-3-Clause
Group: Development/C

Url: https://www.etpan.org/libetpan.html

Vcs: https://github.com/dinhviethoa/libetpan.git
Source: %name-%version.tar
# For cairo-dock-plugins only
Source1: libetpan-config
Patch: %name-%version-%release.patch

# Patches from upstream git. Drop them when
# new version will be released.
Patch2: CVE-2020-15953.patch
Patch3: CVE-2022-4121.patch
Patch4: Fix-potential-null-pointer-deference-348.patch
Patch5: Fix-potential-null-pointer-deferenced-361.patch
Patch6: Fix-potential-null-pointer-deferenced-363.patch
Patch7: Missing-boundary-fix-384.patch
Patch8: CVE-2020-15953-2.patch
Patch9: Fix-buffer-overwrite-for-empty-string-in-remove_trai.patch

# Patch from upstream pull request
# https://github.com/dinhvh/libetpan/pull/436
Patch100: Fix-charconv-double-free.patch
# Patch from upstream pull request
# https://github.com/dinhvh/libetpan/pull/427
Patch101: Fix-FD_SET-undefined-behavior.patch
# Patch from upstream pull request
# https://github.com/dinhvh/libetpan/pull/447
Patch102: Fix-poll-operator-precedence.patch
%def_with gnutls
%def_without openssl

%define _unpackaged_files_terminate_build 1

# FIXME: Is it really needed g++?
BuildRequires: gcc-c++

%{?_with_gnutls:BuildRequires: libgnutls-devel}
%{?_with_openssl:BuildRequires: libssl-devel}
BuildRequires: zlib-devel
BuildRequires: libsasl2-devel
BuildRequires: liblmdb-devel
BuildRequires: liblockfile-devel libexpat-devel libcurl-devel

%package devel
Summary: Development environment for %name library.
Group: Development/C
Requires: %name = %version-%release
%{?_with_gnutls:Requires: libgnutls-devel libgcrypt-devel libgpg-error-devel zlib-devel}
%{?_with_openssl:Requires: libssl-devel}
Requires: libsasl2-devel
Requires: liblmdb-devel
Requires: liblockfile-devel

%description
The purpose of this mail library is to provide a portable, efficient
middleware for different kinds of mail access. When using the drivers
interface, the interface is the same for all kinds of mail access,
remote and local mailboxes.

%description devel
This package contains the header files and libraries for building
program which use lib%name.

%prep
%setup
%patch -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1

%patch100 -p1
%patch101 -p1
%patch102 -p1

ln -s README.md README

%build
%autoreconf
%configure \
	--disable-static \
	%{subst_with openssl} \
	%{subst_with gnutls} \
	--with-poll \
	--enable-lmdb \
	--enable-ipv6
%make_build

%install
%makeinstall_std

# Install libetpan-config
install -Dm0755 %SOURCE1 %buildroot%_bindir/%name-config

%files
%doc ChangeLog NEWS COPYRIGHT README AUTHORS
%_libdir/%name.so.*

%files devel
%_bindir/%name-config
%dir %_includedir/%name
%_includedir/%name/*.h
%_includedir/%name.h
%_pkgconfigdir/%name.pc
%_libdir/%name.so

%changelog
