%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define _libname	enet

Name: libenet
Version: 1.3.13
Release: alt2
Summary: Thin, simple and robust network layer on top of UDP
Group: System/Libraries
License: MIT
Url: http://enet.bespin.org/
Source0: http://enet.bespin.org/download/%_libname-%version.tar.gz

%description
ENet is a relatively thin, simple and robust network communication
layer on top of UDP (User Datagram Protocol). The primary feature
it provides is optional reliable, in-order delivery of packets.

ENet is NOT intended to be a general purpose high level networking
library that handles authentication, lobbying, server discovery,
compression, encryption and other high level, often application
level or dependent tasks.

%package devel
Summary: Development files for enet
Group: Development/C
Requires: %name = %EVR

%description devel
The libenet-devel package contains libraries and header files for
developing applications that use enet.

%package devel-static
Summary: Static library for enet
Group: Development/C
Requires: %name = %EVR

%description devel-static
Static library for enet

%prep
%setup -n %_libname-%version

%build
%add_optflags -D_FILE_OFFSET_BITS=64

export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%configure
%make
gcc -shared -Wl,-soname,%name.so.1 *.o -o %name.so.1

%install
%makeinstall_std
install -pDm644 %name.so.1 %buildroot%_libdir/%name.so.1

install -d %buildroot%_pkgconfigdir
install -m644 *.pc %buildroot%_pkgconfigdir

%files
%doc ChangeLog LICENSE README
%_libdir/%name.so.*

%files devel-static
%_libdir/%name.a

%files devel
%doc docs/html
%_includedir/%_libname
%_libdir/%name.so
%_pkgconfigdir/*

%changelog
