# vim: set ft=spec: -*- rpm-spec -*-

%define _unpackaged_files_terminate_build 1
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: libdockapp
%define major   3
%define libname %{name}%{major}
Version: 0.7.2
Release: alt2
Summary: DockApp Making Standard Library
Group: System/Libraries
License: MIT/X11
Url: http://solfertje.student.utwente.nl/~dalroi/libdockapp/

Source: %name-%version.tar

BuildRequires: libXext-devel libXpm-devel libXt-devel
BuildRequires:  xorg-font-utils

%description
This is a simple (trivial) library for writing Window Maker dock
applications, or dockapps (those that only show up in the dock), easily.

It is very limited and can be only used for dockapps that open a single
appicon for process in only be single display, but this seems to be
enough for most, if not all, dockapps.

%package -n %{libname}
Summary:        A library that eases the creation of dock apps
Group:          System/Libraries

%description -n %{libname}
%{summary}.

%package devel
Summary: DockApp Making Standard Library
Group: Development/C
Requires: %libname = %EVR
Requires: libX11-devel libXpm-devel

%description devel
This is a simple (trivial) library for writing Window Maker dock
applications, or dockapps (those that only show up in the dock), easily.

It is very limited and can be only used for dockapps that open a single
appicon for process in only be single display, but this seems to be
enough for most, if not all, dockapps.

This package contains header files needed for development.

%prep 
%setup

%build
%autoreconf
%configure \
	--disable-static \
	--without-font \
	--without-examples
%make_build

%install
%make_install DESTDIR=%buildroot install
# compat symlink
ln -s %name/dockapp.h %buildroot%_includedir/dockapp.h

%files -n %libname
%doc AUTHORS ChangeLog COPYING NEWS README
%_libdir/lib*.so.%{major}*

%files devel
%doc examples fonts
%_libdir/lib*.so
%dir %_includedir/%name
%_includedir/%name/*.h
%_includedir/*.h
%_pkgconfigdir/*.pc

%changelog
