%define abiversion 22
Name: libdc1394
Version: 2.2.5
Release: alt1.1

Summary: Library for 1394 Digital Camera Specification

License: LGPL v2.1
Group: System/Libraries
Url: http://sf.net/projects/libdc1394/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://prdownloads.sf.net/%name/%name-%version.tar.bz2

Patch1: libdc1394-13b85d2d23548682b617ddc1196f5560a27998bd.patch
Patch2: libdc1394-2.1.3-alt-v4l.patch
Patch2000: libdc1394-e2k.patch

%define libraw1394_ver 2.0.4
Requires: libraw1394 >= %libraw1394_ver
BuildPreReq: libraw1394-devel >= %libraw1394_ver
BuildPreReq: libv4l-devel

# Automatically added by buildreq on Mon Jul 06 2009
BuildRequires: doxygen gcc-c++ imake libSM-devel libX11-devel libXext-devel libXv-devel libraw1394-devel libusb-devel

%description
libdc1394 is a library that is intended to provide a high level
programming interface for application developers who wish to control
IEEE 1394 based cameras that conform to the 1394-based Digital Camera
Specification (found at http://www.1394ta.org/).

%package -n %name-%abiversion
Summary: Library for 1394 Digital Camera Specification
Group: System/Libraries

%description -n %name-%abiversion
libdc1394 is a library that is intended to provide a high level
programming interface for application developers who wish to control
IEEE 1394 based cameras that conform to the 1394-based Digital Camera
Specification (found at http://www.1394ta.org/).

%package devel
Summary: Development components for libdc1394
Group: Development/C
Requires: %name-%abiversion = %version-%release
Requires: libraw1394-devel >= %libraw1394_ver

%description devel
This package contains the header-files for libdc1394 development.

%package tools
Summary: Development and include files for %name
Group: System/Kernel and hardware
Requires: %name-%abiversion = %version-%release

%description tools
libraw1394 is the only supported interface to the kernel side raw1394 of
the Linux IEEE-1394 subsystem, which provides direct access to the connected
1394 buses to user space.  Through libraw1394/raw1394, applications can
directly send to and receive from other nodes without requiring a kernel driver
for the protocol in question.

This package provides tools to dump, send, format IEEE 1394
isochronous channel packets and test %name basic functionality.

%prep
%setup
%ifarch %e2k
%patch2000 -p1
sed -E -i 's/u\.(reset|response|resource)/u->\1/g' dc1394/juju/control.c
sed -i 's/iso\.i/iso->i/g' dc1394/juju/capture.c
%endif

#patch1 -p2
#patch2 -p2

%build
%__subst "s|runpath_var=.*|runpath_var=|g" configure
%configure --disable-static
%__subst "s|hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=|g" libtool
%make_build

%install
%makeinstall_std

%files -n %name-%abiversion
%doc AUTHORS ChangeLog NEWS README
%_libdir/lib*.so.*

%files devel
%_includedir/dc1394/
%_libdir/*.so
%_pkgconfigdir/*

%files tools
#%_bindir/dc1394_vloopback
%_bindir/dc1394_reset_bus
%_man1dir/*

%changelog
