%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%def_with firebird
%def_without sqlite2
%def_disable doc

Name: libdbi-drivers
Epoch: 1
Version: 0.9.0
Release: alt7.1
Summary: Database drivers for libdbi
License: LGPL
Group: System/Libraries
Url: http://libdbi-drivers.sourceforge.net/

Source: %name-%version.tar
Patch: 0001-freetds-resolve-compile-error-with-1.0.patch

Patch2: libdbi-drivers-fedora-sys-wait.patch
Patch3: libdbi-drivers-fedora-c99.patch
Patch4: libdbi-drivers-alt-firebird-driver-gcc14-fix.patch
Patch5: libdbi-drivers-alt-firebird-driver-proper-pvector-type.patch

# Automatically added by buildreq on Mon Feb 09 2009
BuildRequires: gcc-c++ libdbi-devel zlib-devel
BuildRequires: libMySQL-devel postgresql-devel
BuildRequires: libfreetds-devel
BuildRequires: libsqlite3-devel
%{?_with_sqlite2:BuildRequires: libsqlite-devel}
%{?_with_firebird:BuildRequires: firebird-devel docbook-style-dsssl jadetex}
%{?_enable_doc:BuildRequires: docbook-style-dsssl jadetex openjade}

%description
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

%package dbd-mysql
Summary: MySQL driver for libdbi
Group: System/Libraries

%description dbd-mysql
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This driver provides connectivity to MySQL database servers through the libdbi
database independent abstraction layer. Switching a program's driver does not
require recompilation or rewriting source code.

%package dbd-pgsql
Summary: PostgreSQL driver for libdbi
Group: System/Libraries

%description dbd-pgsql
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This driver provides connectivity to PostgreSQL database servers through the
libdbi database independent abstraction layer. Switching a program's driver
does not require recompilation or rewriting source code.

%if_with sqlite2
%package dbd-sqlite
Summary: SQLite driver for libdbi
Group: System/Libraries

%description dbd-sqlite
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This driver provides connectivity to SQLite database servers through the libdbi
database independent abstraction layer. Switching a program's driver does not
require recompilation or rewriting source code.

%endif

%package dbd-sqlite3
Summary: SQLite3 driver for libdbi
Group: System/Libraries

%description dbd-sqlite3
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This driver provides connectivity to SQLite3 database servers through the
libdbi database independent abstraction layer. Switching a program's driver
does not require recompilation or rewriting source code.

%package dbd-freetds
Summary: MSSQL (FreeTDS) driver for libdbi
Group: System/Libraries

%description dbd-freetds
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This driver provides connectivity to MSSQL database servers through the libdbi
database independent abstraction layer. Switching a program's driver does not
require recompilation or rewriting source code.

%package dbd-firebird
Summary: Firebird driver for libdbi
Group: System/Libraries

%description dbd-firebird
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This driver provides connectivity to Firebird database servers through the libdbi
database independent abstraction layer. Switching a program's driver does not
require recompilation or rewriting source code.

%package devel
Summary: Header files for the %name library drivers
Group: Development/C
Provides: %name-drivers-devel
Requires: libdbi-devel >= 0.8.2

%description devel
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This package contains header files.

%package doc
Summary: Docs for the %name library drivers
Group: Development/C
Provides: %name-drivers-devel
Requires: libdbi-devel >= 0.8.2

%description doc
libdbi implements a database-independent abstraction layer in C, similar to the
DBI/DBD layer in Perl. Writing one generic set of code, programmers can
leverage the power of multiple databases and multiple simultaneous database
connections by using this framework.

This package contains the doc.

%prep
%setup
%autopatch -p1

# lib64 fix
sed -i "s|/lib\b|/%_lib|g" acinclude.m4

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure \
    --disable-static \
    --with-mysql \
    --with-pgsql \
%if_with sqlite2
    --with-sqlite \
%endif
    --with-sqlite3 \
    --with-freetds \
    --with-freetds-incdir=%_includedir \
    --with-freetds-libdir=%_libdir \
    --with-dbi-incdir=%_includedir/dbi \
    --with-dbi-libdir=%_libdir \
    --localstatedir=%_var \
    --sharedstatedir=%_var \
    %{subst_with firebird} \
    %{subst_enable docs} \
    %nil

%make_build

%install
%makeinstall_std

# install development headers
install -d %buildroot%_includedir/dbi
install -pm0644 drivers/mysql/dbd_mysql.h %buildroot%_includedir/dbi/
install -pm0644 drivers/pgsql/dbd_pgsql.h %buildroot%_includedir/dbi/
%if_with sqlite2
install -pm0644 drivers/sqlite/dbd_sqlite.h %buildroot%_includedir/dbi/
%endif
install -pm0644 drivers/sqlite3/dbd_sqlite3.h %buildroot%_includedir/dbi/
install -pm0644 drivers/freetds/dbd_freetds.h %buildroot%_includedir/dbi/
%if_with firebird
install -pm0644 drivers/firebird/dbd_firebird.h %buildroot%_includedir/dbi/
%endif

%if_enabled docs
# fix some docs
cp -a drivers/mysql/TODO TODO.mysql
cp -a drivers/pgsql/TODO TODO.pgsql
%if_with sqlite2
cp -a drivers/sqlite/TODO TODO.sqlite
%endif
cp -a drivers/sqlite3/TODO TODO.sqlite3
%if_with firebird
cp -a drivers/firebird/TODO TODO.firebird
%endif
%else
# firebird tries to build those unconditionally
rm -rf %buildroot%_docdir/*
%endif

# remove unpackaged files
rm -f %buildroot%_libdir/dbd/*.la

%files dbd-mysql
%doc drivers/mysql/README
%_libdir/dbd/libdbdmysql.so

%files dbd-pgsql
%doc drivers/pgsql/README
%_libdir/dbd/libdbdpgsql.so

%if_with sqlite2
%files dbd-sqlite
%doc drivers/sqlite/README
%_libdir/dbd/libdbdsqlite.so
%endif

%files dbd-sqlite3
%doc drivers/sqlite3/README
%_libdir/dbd/libdbdsqlite3.so

%files dbd-freetds
%doc drivers/freetds/README
%_libdir/dbd/libdbdfreetds.so

%if_with firebird
%files dbd-firebird
%doc drivers/firebird/README
%_libdir/dbd/libdbdfirebird.so
%endif

%files devel
%doc AUTHORS ChangeLog INSTALL README TODO*
%_includedir/dbi/*.h

%if_enabled docs
%files doc
%_docdir/*
%exclude %_docdir/*devel*
%endif

%changelog
