%def_disable static
%def_with apidocs

Name: libdaemon
Version: 0.14
Release: alt2.1

Summary: Lightweight C library which eases the writing of UNIX daemons
License: LGPL
Group: System/Libraries
Url: http://0pointer.de/lennart/projects/libdaemon/

Source: %name-%version-%release.tar

%{?_with_apidocs:BuildRequires: doxygen lynx}

%description
libdaemon is a leightweight C library which eases the writing of UNIX daemons.
It consists of the following parts:

 * A wrapper around fork() which does the correct daemonization
   procedure of a process
 * A wrapper around syslog() for simpler and compatible log output to
   Syslog or STDERR
 * An API for writing PID files
 * An API for serializing UNIX signals into a pipe for usage with
   select() or poll()

Routines like these are included in most of the daemon software available. It
is not that simple to get it done right and code duplication cannot be a goal.

%package devel
Summary: Development part of libdaemon
Group: Development/C
Requires: %name = %version-%release

%package devel-static
Summary: Static libraries from libdaemon
Group: Development/C
Requires: %name-devel = %version-%release

%description devel
This is the development part (header files and documentation) for 
%name.

%description devel-static
This package contains static library to build statically linked %name
applications.

%prep
%setup

%build
%autoreconf
%configure %{subst_enable static} 
make all %{?_with_apidocs:doxygen}

%install
%makeinstall
install -d %buildroot%_man3dir
%if_with apidocs
cp -a doc/reference/man/* %buildroot%_mandir/
%endif

%files
%_libdir/*.so.*

%files devel
%if_with apidocs
%doc doc/README doc/reference/html/
%_man3dir/*
%endif
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/%name/

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
