Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# The base of the version (just major and minor without point)
%global base_version 1.10

Name:           libcutl
Version:        %{base_version}.0
Release:        alt1_32
Summary:        C++ utility library from Code Synthesis

#Used internal Boost files
# Automatically converted from old format: MIT and Boost - review is highly recommended.
License:        LicenseRef-Callaway-MIT AND BSL-1.0
URL:            http://www.codesynthesis.com/projects/libcutl/
Source0:        http://www.codesynthesis.com/download/libcutl/%{base_version}/%{name}-%{version}.tar.bz2
Patch0:         libcutl_no_boost_license.patch

BuildRequires:  gcc
BuildRequires:  gcc-c++

# Use internal Boost
#BuildRequires: boost-devel
Provides: bundled(boost) = 1.54

# Uses pkgconfig
BuildRequires: libexpat-devel
Source44: import.info

%description
libcutl is a C++ utility library. It contains a collection of generic and
fairly independent components.

%package        devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -q

rm -rv cutl/details/expat
cp -p cutl/details/boost/LICENSE cutl/details/boost/boost-LICENSE

%build
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"
%configure --disable-static --with-external-expat
%make_build

%install
%makeinstall_std
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'
rm -rf $RPM_BUILD_ROOT%{_datadir}

%files
%doc --no-dereference LICENSE cutl/details/boost/boost-LICENSE
%{_libdir}/libcutl-%{base_version}.so

%files devel
%doc NEWS
%{_includedir}/cutl/
%{_libdir}/libcutl.so
%{_libdir}/pkgconfig/libcutl.pc

%changelog
