Name: libcmis
Version: 0.6.2
Release: alt1.1

Summary: A C++ client library for the CMIS interface
License: GPLv2+ or LGPLv2+ or MPL-1.1
Group: System/Libraries

Url: https://github.com/tdf/libcmis
Source: %name-%version.tar
Patch: %name-0.4.1-alt2.1.patch
Patch1: libcmis-0.6.2-upstream-fix-build-with-boost-1.86.0.patch

BuildRequires: gcc-c++
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(cppunit) >= 1.12

BuildRequires: boost-devel boost-program_options-devel
BuildRequires: doxygen
BuildRequires: xmlto

%description
LibCMIS is a C++ client library for the CMIS interface. This allows C++
applications to connect to any ECM behaving as a CMIS server like
Alfresco, Nuxeo for the open source ones.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package tools
Summary: Command line tool to access CMIS
Group: Publishing
Requires: %name = %version-%release

%description tools
The %name-tools package contains a tool for accessing CMIS from the
command line.

%prep
%setup
%patch -p1
%patch1 -p1

%build
touch ChangeLog
mkdir -p m4
%autoreconf
%configure --disable-static --disable-werror --disable-tests \
	DOCBOOK2MAN='xmlto man'
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS COPYING.* NEWS README.md
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files tools
%_bindir/*
%_man1dir/*.1*

%changelog
