# TODO: correct clip-glade linking with clip-gtk
# TODO: correct clip-gd linking with libpng, libtiff, and so on
# TODO: build clip-gd with system libgd, not internal
# TODO: what is locale.pot?

%define FCLIPDIR %_libdir/clip
%define VCLIPDIR %_localstatedir/clip

Name: libclip
Version: 1.2.0cvs
Release: alt8

Summary: XBASE/Clipper compatible program compiler - runtime library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --  

License: GPL
Group: Development/Other
Url: http://www.itk.ru

Packager: Vitaly Lipatov <lav@altlinux.ru>

# see clip.spec
ExcludeArch: aarch64 armh

Source: %name-%version.tar.bz2
#Source10: %name-%version-2005-02-03.tar.bz2
Patch: %name-%version-ezV24.patch
Patch1: %name-1.2.0cvs-alt-linking.patch
Patch2: %name-1.2.0cvs-alt-libpng15.patch
Patch3: %name-openssl1.1.patch

# TODO: fix linking
%set_verify_elf_method unresolved=relaxed
%add_findprov_lib_path %FCLIPDIR/lib


# manually removed: linux-libc-headers 
# Automatically added by buildreq on Mon Sep 11 2006
BuildRequires: bzlib-devel clip libexpat-devel libfcgi-devel libglade-devel libgpm-devel libjpeg-devel libMySQL-devel libunixODBC-devel libXpm-devel postgresql-devel libpth-devel libezV24-devel zlib-devel libssl-devel libpng-devel libtiff-devel libgd-devel
# do not use gtk1: libgtk+extra-devel 

BuildPreReq: clip = %version

%description
This package provides runtime shared libraries for CLIP package

%description -l ru_RU.KOI8-R
      
 CLIP.

############################################################################
%package -n %name-all
Summary: XBASE/Clipper compatible program compiler - all additional library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --   
Group: Development/Other

#Requires: %name-ui
Requires: %name-common = %version-%release
Requires: %name-gd = %version-%release
#Requires: %name-gtk = %version-%release
Requires: %name-gtk2 = %version-%release
#Requires: %name-interbase = %version-%release
Requires: %name-mysql = %version-%release
Requires: %name-odbc = %version-%release
Requires: %name-postgres = %version-%release

%description -n %name-all
This virtual package provides all runtime shared libraries for CLIP package
%name-common
%name-gtk
- %name-gtk
%name-gtk2
- %name-interbase
%name-mysql
%name-odbc
%name-postgres

%description -n %name-all -l ru_RU.KOI8-R
    ӣ    
 CLIP.
%name-common
%name-gd
- %name-gtk
%name-gtk2
- %name-interbase
%name-mysql
%name-odbc
%name-postgres

############################################################################
%package -n %name-common
Summary: XBASE/Clipper compatible program compiler - common library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --  
Group: Development/Other

Requires: %name >= %version

%description -n %name-common
This package provides common runtime shared libraries for CLIP

%description -n %name-common -l ru_RU.KOI8-R
       
 CLIP.

############################################################################
%package -n %name-gtk
Summary: XBASE/Clipper compatible program compiler - gtk library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --  gtk
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-gtk
This package provides gtk runtime shared libraries for CLIP

%description -n %name-gtk -l ru_RU.KOI8-R
       gtk  CLIP.

############################################################################
%package -n %name-gd
Summary: XBASE/Clipper compatible program compiler - gd library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --  gd
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-gd
This package provides gd runtime shared libraries for CLIP

%description -n %name-gd -l ru_RU.KOI8-R
       gd  CLIP.

############################################################################
%package -n %name-gtk2
Summary: XBASE/Clipper compatible program compiler - gtk2 library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --  gtk2
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-gtk2
This package provides gtk2 runtime shared libraries for CLIP

%description -n %name-gtk2 -l ru_RU.KOI8-R
       gtk2  CLIP.

############################################################################
%package -n %name-ui
Summary: XBASE/Clipper compatible program compiler - ui library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --  ui
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-ui
This package provides ui runtime shared libraries for CLIP

%description -n %name-ui -l ru_RU.KOI8-R
       ui  CLIP.

############################################################################
%package -n %name-interbase
Summary: XBASE/Clipper compatible program compiler - library for database Interbase
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --     Interbase
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-interbase
This package provides library for using database Interbase in CLIP.

%description -n %name-interbase -l ru_RU.KOI8-R
        Interbase  CLIP.

############################################################################
%package -n %name-mysql
Summary: XBASE/Clipper compatible program compiler - library for database MySQL
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --     MySQL
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-mysql
This package provides library for using database MySQL in CLIP.

%description -n %name-mysql -l ru_RU.KOI8-R
        MySQL  CLIP.

############################################################################
%package -n %name-odbc
Summary: XBASE/Clipper compatible program compiler - library for ODBC
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --   ODBC
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-odbc
This package provides library for using ODBC in CLIP.

%description -n %name-odbc -l ru_RU.KOI8-R
         ODBC  CLIP.

############################################################################
%package -n %name-postgres
Summary: XBASE/Clipper compatible program compiler - library for database Postgre
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --     Postgre
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-postgres
This package provides library for using database Postgre in CLIP.

%description -n %name-postgres -l ru_RU.KOI8-R
        Postgre  CLIP.

############################################################################

%package -n %name-fcgi
Summary: XBASE/Clipper compatible program compiler - fcgi library
Summary(ru_RU.KOI8-R):   XBASE/Clipper   --  fcgi
Group: Development/Other

Requires: %name-common = %version-%release

%description -n %name-fcgi
This package provides fcgi runtime shared libraries for CLIP

%description -n %name-fcgi -l ru_RU.KOI8-R
       fcgi  CLIP.

%prep
%setup -q
%patch1 -p2
%patch
%patch2 -p2
%patch3 -p2
# incorrect checking
echo > clip-ui/configure
cp clip-ui/Makefile.in clip-ui/Makefile
# fix /usr/lib
%__subst "s|/usr/lib|%_libdir|g" clip-gd/gd/configure

%build
# for locale.pot
export CLIP_LOCALE_ROOT=`pwd`

make CLIPROOT=%FCLIPDIR

%install
mkdir -p %buildroot%FCLIPDIR/{include,etc,cliprc,lib}
make install DESTDIR=%buildroot CLIPROOT=%FCLIPDIR
mkdir -p %buildroot%VCLIPDIR
cp -rf locale.pot %buildroot%VCLIPDIR/

# fix broken installer in source
mkdir -p %buildroot%_docdir
mv %buildroot%FCLIPDIR/doc %buildroot%_docdir/%name-%version
mv %buildroot%FCLIPDIR/locale.po %buildroot%VCLIPDIR

%files -n %name-all

%files -n %name-gd
%_docdir/%name-%version/clip-gd
%_docdir/%name-%version/example/clip-gd
%FCLIPDIR/include/gd*
%FCLIPDIR/lib/%name-gd.so

%files -n %name-gtk2
%_docdir/%name-%version/example/clip-gtk2
%FCLIPDIR/include/*gtk2*
%config %FCLIPDIR/cliprc/clip-gtk2.cliprc
%FCLIPDIR/lib/%name-gtk2.so
%FCLIPDIR/lib/%name-glade2.so
%VCLIPDIR/locale.pot/clip-gtk2

%files -n %name-ui
%_docdir/%name-%version/example/clip-ui
%FCLIPDIR/include/clip-ui*
#%config %FCLIPDIR/cliprc/clip-gtk2.cliprc
%FCLIPDIR/lib/%name-ui.so
%FCLIPDIR/lib/drivers
%VCLIPDIR/locale.po/*/*
%VCLIPDIR/locale.pot/clip-ui

%define build_interbase 0
%if %build_interbase
%files -n %name-interbase
%_docdir/%name-%version/clip-interbase
%_docdir/%name-%version/example/clip-interbase
%FCLIPDIR/include/interbase*
%FCLIPDIR/lib/%name-interbase.so
%endif

%files -n %name-mysql
%_docdir/%name-%version/clip-mysql
%_docdir/%name-%version/example/clip-mysql
%FCLIPDIR/include/mysql*
%FCLIPDIR/lib/%name-mysql.so

%files -n %name-odbc
#%_docdir/%name-%version/example/clip-odbc
#%FCLIPDIR/include/clip-odbc
%FCLIPDIR/lib/%name-odbc.so

%files -n %name-postgres
%_docdir/%name-%version/clip-postgres
%_docdir/%name-%version/example/clip-postgres
%FCLIPDIR/include/postgres*
%FCLIPDIR/lib/%name-postgres.so

%files -n %name-fcgi
%_docdir/%name-%version/example/clip-fcgi
%FCLIPDIR/include/fcgi.ch
%FCLIPDIR/lib/%name-fcgi.so

%files -n %name-common
%dir %_docdir/%name-%version
%_docdir/%name-%version/clip-com/
#%_docdir/%name-%version/example/clip-fw
%dir %_docdir/%name-%version/example/
%_docdir/%name-%version/example/clip-gzip
%_docdir/%name-%version/example/clip-bzip2
%_docdir/%name-%version/example/clip-com
%_docdir/%name-%version/example/clip-crypto
#%_docdir/%name-%version/example/clip-cti
%_docdir/%name-%version/example/clip-rtf
%_docdir/%name-%version/example/clip-xml
%_docdir/%name-%version/example/clip-postscript
%FCLIPDIR/include/clip-expat*
%FCLIPDIR/include/clip-postscript*
#%FCLIPDIR/include/fwin
#%FCLIPDIR/include/cti
#%FCLIPDIR/include/cti.ch
%FCLIPDIR/include/bggraph.ch
%FCLIPDIR/include/nanfor
%FCLIPDIR/include/netto
%FCLIPDIR/include/object*
%FCLIPDIR/include/rich*
#%FCLIPDIR/include/bg*
%FCLIPDIR/include/r2d2*
#%FCLIPDIR/etc/.calendar
%FCLIPDIR/lib/libclip-bzip2.so
%FCLIPDIR/lib/libclip-com.so
%FCLIPDIR/lib/libclip-crypto.so
%FCLIPDIR/lib/libclip-postscript.so
#%FCLIPDIR/lib/libclip-fw.so
#%FCLIPDIR/lib/libclip-cti.so
%FCLIPDIR/lib/libclip-gzip.so
%FCLIPDIR/lib/libclip-nanfor.so
%FCLIPDIR/lib/libclip-netto.so
%FCLIPDIR/lib/libclip-rtf.so
%FCLIPDIR/lib/libclip-r2d2.so
%FCLIPDIR/lib/libclip-xml.so
#%config %FCLIPDIR/cliprc/*
%VCLIPDIR/locale.pot/clip-r2d2
%exclude %FCLIPDIR/lib/*.a

%changelog
