# XXX: packaged binaries contain GPU-targeted IR code. Native
# linker is not used for building them. %%optflags_lto apply only when
# building native binaries, and LTO causes problems on LoongArch.
# To keep things simple disable LTO everywhere:
%global optflags_lto %nil
# libclc itself can be built by any LLVM but newer is preferred
# cause it contains better optimisations and improvements
%global llvm_version 20.1

Name: libclc
Version: 20.1.7
Release: alt1
Summary: An open source implementation of the OpenCL 1.1 library requirements
License: BSD
Group: System/Libraries
URL: https://libclc.llvm.org

# https://github.com/llvm/llvm-project/releases/download/llvmorg-%version/%name-%version.src.tar.xz
Source: %name-%version.src.tar
Patch: libclc-llvm-spirv-path.patch

BuildRequires(pre): cmake /proc
BuildRequires: python3 libstdc++-devel
BuildRequires: llvm-spirv >= %{llvm_version}.0, clspv
BuildRequires: clang%{llvm_version} llvm%{llvm_version}-devel

# clc code is IR code
BuildArch: noarch

%description
libclc is an open source, BSD licensed implementation of the library
requirements of the OpenCL C programming language, as specified by the
OpenCL 1.1 Specification. The following sections of the specification
impose library requirements:

  * 6.1: Supported Data Types
  * 6.2.3: Explicit Conversions
  * 6.2.4.2: Reinterpreting Types Using as_type() and as_typen()
  * 6.9: Preprocessor Directives and Macros
  * 6.11: Built-in Functions
  * 9.3: Double Precision Floating-Point
  * 9.4: 64-bit Atomics
  * 9.5: Writing to 3D image memory objects
  * 9.6: Half Precision Floating-Point

libclc is intended to be used with the Clang compiler's OpenCL frontend.

libclc is designed to be portable and extensible. To this end, it provides
generic implementations of most library requirements, allowing the target
to override the generic implementation at the granularity of individual
functions.

libclc currently only supports the PTX target, but support for more
targets is welcome.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name

%prep
%setup -q -n %name-%version.src
%patch -p2

%build
export ALTWRAP_LLVM_VERSION=%{llvm_version}
%cmake \
	-DCMAKE_C_COMPILER=clang \
	-DCMAKE_CXX_COMPILER=clang++ \
	%nil

%cmake_build

%install
%cmake_install

%files
%doc LICENSE.TXT README.md CREDITS.TXT
%_datadir/clc

%files devel
%_includedir/clc
%_datadir/pkgconfig/*.pc

%changelog
