%define ver_major 128
%define _name cjs
%define api_ver 1.0

%def_disable check

Name: lib%_name
Version: %ver_major.0
Release: alt2

Summary: Javascript Bindings for Cinnamon
Group: System/Libraries
# The following files contain code from Mozilla which
# is triple licensed under MPL1.1/LGPLv2+/GPLv2+:
# The console module (modules/console.c)
# Stack printer (cjs/stack.c)
License: MIT and (MPL-1.1 or GPLv2+ or LGPLv2+)
Url: https://github.com/linuxmint/cjs

Source: %name-%version.tar
Patch: %name-%version-%release.patch

%define glib_ver 2.33.14
%define gi_ver 1.33.14
%ifarch %valgrind_arches
%def_with valgrind
%else
%def_without valgrind
%endif

BuildRequires(pre): rpm-macros-valgrind
BuildRequires: gcc-c++ libcairo-devel
BuildRequires: glib2-devel >= %glib_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libdbus-glib-devel libreadline-devel libcairo-gobject-devel
BuildRequires: gnome-common
BuildRequires: libmozjs128-devel
BuildRequires: meson
BuildRequires: pkgconfig(sysprof-capture-4)
%if_with valgrind
BuildRequires: valgrind
%endif
%{?_enable_check:BuildRequires: /proc xvfb-run dbus-tools dbus-tools-gui
BuildRequires: typelib(Clutter) typelib(Gtk) = 3.0}

# for check
BuildRequires: /proc dbus-tools-gui

%description
Cjs allows using GNOME/Cinnamon libraries from Javascript. It's based on the
Spidermonkey Javascript engine from Mozilla and the GObject introspection
framework.

%package devel
Summary: Development package for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Files for development with %name.

%set_typelibdir %_libdir/%_name/girepository-1.0


%prep
%setup
%autopatch -p1

%build
%meson
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
xvfb-run %meson_test

%files
%_bindir/%_name
%_bindir/%_name-console
%_libdir/*.so.*
%dir %_datadir/cjs-1.0
%dir %_libdir/%_name/
%dir %_libdir/%_name/girepository-1.0
%_libdir/%_name/girepository-1.0/CjsPrivate-%api_ver.typelib
%doc COPYING NEWS README.md

%files devel
%_includedir/%_name-%api_ver/
%_libdir/*.so
%_libdir/pkgconfig/%_name-%api_ver.pc
%_datadir/cjs-1.0/lsan
%if_with valgrind
%_datadir/cjs-1.0/valgrind
%endif

%doc examples/*

%changelog
