Name: libassuan
Version: 2.5.6
Release: alt1

Summary: IPC library used by some GnuPG related software
License: GPL-3.0-or-later AND LGPL-2.1-or-later
Group: System/Libraries
Url: https://www.gnupg.org/

Source: libassuan-%version.tar
Patch1: 0001-Fix-LFS-on-32-bit-systems.patch
Patch2: 0002-ALT-version-is-not-beta.patch

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%set_verify_elf_method strict

BuildRequires: pkgconfig(gpg-error)
BuildRequires: makeinfo

%package devel
Summary: Development files for the libassuan library
Group: Development/C
Requires: %name = %version-%release
Conflicts: libassuan0-devel

%description
This is the IPC library used by GnuPG 2, GPGME and a few other packages.

%description devel
This package contains development files for the libassuan library.

%prep
%setup
%autopatch -p1

# Rename library: libassuan -> libassuan2.
sed -i 's/libassuan\(.la\)/libassuan2\1/g' */Makefile.am

cat > doc/version.texi <<EOF
@set UPDATED $(LANG=C date -u -r doc/assuan.texi +'%%d %%B %%Y')
@set UPDATED-MONTH $(LANG=C date -u -r doc/assuan.texi +'%%B %%Y')
@set EDITION %version
@set VERSION %version
EOF

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
mv %buildroot%_libdir/libassuan{2,}.so

%check
%make_build check

%files
%doc AUTHORS NEWS README
%_libdir/lib*.so.*

%files devel
%_bindir/libassuan-config
%_libdir/*.so
%_includedir/*.h
%_datadir/aclocal/*.m4
%_infodir/*.info*
%_pkgconfigdir/*.pc

%changelog
