%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define oname aom
%define soname 3
%define libname lib%{oname}%{soname}

# tests require downloading ~750Mb of video data
# and run really long (up to a few hours)
%def_disable longcheck
%def_enable doc

# TODO: remove later this fix for documentation
%define _cmake__builddir BUILD

Name: lib%oname
Version: 3.13.1
Release: alt1
Summary: AV1 Codec Library
Group: System/Libraries
License: BSD-2-Clause
Url: https://aomedia.org/
VCS: https://aomedia.googlesource.com/aom
Source: %name-%version.tar
# ffmpeg -i testdata/rush_hour_444.y4m -vframes 10 -pix_fmt yuv420p rush_hour_420.yuv
Source1: rush_hour_420.yuv

Patch1: %name-alt-version.patch
Patch2: %name-alt-dont-install-static-libs.patch
Patch2000: %name-e2k-simd.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++ doxygen
%if_with doc
# build dependencies of graphviz are insane
BuildRequires: /usr/bin/dot
%endif
%ifarch %ix86 x86_64
BuildRequires: yasm
%endif
%if_enabled longcheck
BuildRequires: python3
%endif

%description
AOMedia Video 1, almost universally referred to as AV1,
is an open, royalty-free video coding format designed
for video transmissions over the Internet.

%package -n %libname
Summary: AV1 Codec Library
Group: System/Libraries

%description -n %libname
AOMedia Video 1, almost universally referred to as AV1,
is an open, royalty-free video coding format designed
for video transmissions over the Internet.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %libname = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package tools
Summary: Tools for %name
Group: Other
Requires: %libname = %EVR

%description tools
The %name-tools package contains tools for %name.

%package docs
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch
Requires: %libname = %EVR

%description docs
The %name-docs package contains documentation files for %name.

%prep
%setup
%patch1 -p1
%patch2 -p1
cp -p %SOURCE1 .
%ifarch %e2k
%patch2000 -p1
%endif

# Override old version from changelog
echo -n %version > version

%build
%cmake \
	-DCMAKE_BUILD_TYPE:STRING=RelWithDebInfo \
	-DBUILD_SHARED_LIBS:BOOL=ON \
%ifarch armh ppc64le loongarch64
	-DAOM_TARGET_CPU:STRING=generic \
%endif
%ifarch riscv64
	-DENABLE_RVV:BOOL=OFF \
%endif
%if_enabled doc
	-DENABLE_DOCS:BOOL=ON \
%else
	-DENABLE_DOCS:BOOL=OFF \
%endif
	-DENABLE_EXAMPLES:BOOL=ON \
	-DENABLE_TOOLS:BOOL=ON \
%if_disabled longcheck
	-DENABLE_TESTS:BOOL=OFF \
%endif
	%nil

%cmake_build

%install
%cmakeinstall_std

%check
# simple check using examples
export LD_LIBRARY_PATH=%buildroot%_libdir
%_cmake__builddir/examples/lossless_encoder 352 288 rush_hour_420.yuv rush_hour_420.av1
%_cmake__builddir/examples/simple_decoder rush_hour_420.av1 output.yuv
cmp rush_hour_420.yuv output.yuv

%if_enabled longcheck
# just add test data and correspondingly modify test data path
# NOTE: running tests may take very long time
export LIBAOM_TEST_DATA_PATH=$(pwd)/testdata
export LD_LIBRARY_PATH=%buildroot%_libdir:$(pwd)/%_cmake__builddir/third_party/googletest/src/googletest
%make -C %_cmake__builddir runtests
%endif

%files -n %libname
%doc LICENSE PATENTS README.md
%_libdir/libaom.so.%soname
%_libdir/libaom.so.%version

%files devel
%_includedir/%oname
%_libdir/*.so
%_pkgconfigdir/*.pc
%_cmakedir/AOM

%files tools
%_bindir/*

%if_enabled doc
%files docs
%doc %_cmake__builddir/docs/html
%endif

%changelog
