Name: libaio
Version: 0.3.113
Release: alt2

Summary: Linux-native asynchronous I/O access library
License: LGPLv2+
Group: System/Libraries
Url: https://pagure.io/libaio
Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires: /proc

%description
The Linux-native asynchronous I/O facility ("async I/O", or "aio") has a richer
API and capability set than the simple POSIX async I/O facility. This library,
libaio, provides the Linux-native API for async I/O. The POSIX async I/O
facility requires this library in order to provide kernel-accelerated async I/O
capabilities, as do applications which require the Linux-native async I/O API.

%package devel
Summary: Development files for Linux-native asynchronous I/O access
Group: Development/C
Requires: libaio = %version-%release

%description devel
This package provides header files to include and libraries to link with
for the Linux-native asynchronous I/O facility ("async I/O", or "aio").

%package devel-static
Summary: Linux-native asynchronous I/O access static library
Group: Development/C
Requires: libaio-devel = %version-%release

%description devel-static
This package contains static library for
the Linux-native asynchronous I/O facility ("async I/O", or "aio").

%prep
%setup
%patch -p1

%build
%make_build

%install
%makeinstall_std \
	prefix=%_prefix libdir=/%_lib usrlibdir=%_libdir

%check
%make partcheck

%files
/%_lib/*.so.*

%files devel
%_libdir/*.so
%_includedir/*

%files devel-static
%_libdir/*.a

%changelog
