%def_disable snapshot
%define ver_major 1.8
%define beta %nil
%define namespace Adw
%define api_ver 1
%define xdg_name org.gnome.Adwaita%api_ver

%def_enable introspection
%def_enable vala
%def_enable gtk_doc
%def_enable examples
%def_disable check

Name: libadwaita
Version: %ver_major.1
Release: alt1%beta
Epoch: 1

Summary: Library with GTK4 widgets for mobile devices
Group: System/Libraries
License: LGPL-2.1-or-later
Url: https://gitlab.gnome.org/GNOME/libadwaita

Vcs: https://gitlab.gnome.org/GNOME/libadwaita.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define meson_ver 0.63
%define glib_ver 2.80.0
%define gtk_ver 4.17.5
%define gi_ver 1.84

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson >= %meson_ver sassc
BuildRequires: pkgconfig(gio-2.0) >= %glib_ver
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: libfribidi-devel
BuildRequires: libappstream-devel
%{?_enable_introspection:BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel >= %gi_ver gir(Gtk) = 4.0}
%{?_enable_vala:BuildRequires(pre): rpm-build-vala
BuildRequires: vala-tools}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_check:BuildRequires: xvfb-run librsvg xdg-desktop-portal}

%description
libadwaita is a collection of GTK4 widgets for adaptive applications
targeting form-factors from mobile to desktop. It also offers innovative
widgets following the GNOME design guidelines.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name library.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the %name library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %EVR

%description devel-doc
This package contains development documentation for %name library.

%package demo
Summary: %name widgets demonstration programs
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description demo
This package contains a program, along with its source code, that
demonstrates %name variety of all its widgets.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool examples examples}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
xvfb-run -s -noreset %__meson_test

%files -f %name.lang
%_libdir/%name-%api_ver.so.*
%doc README.md NEWS

%files devel
%_includedir/%name-%api_ver/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%{?_enable_vala:%_vapidir/%name-%api_ver.*}

%if_enabled introspection
%files gir
%_typelibdir/%namespace-%api_ver.typelib

%files gir-devel
%_girdir/%namespace-%api_ver.gir
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/%name-%api_ver/
%endif

%if_enabled examples
%files demo
%_bindir/adwaita-%api_ver-demo
%_desktopdir/%{xdg_name}.Demo.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}.Demo*.svg
%_datadir/metainfo/%{xdg_name}.Demo.metainfo.xml
%endif

%changelog
