%add_optflags %optflags_shared -fcommon
Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libacpi
Version:        0.2
Release:        alt2_32
Summary:        General purpose library for ACPI 

License:        MIT
URL:            http://www.ngolde.de/libacpi.html
Source0:        http://www.ngolde.de/download/%{name}-%{version}.tar.gz
Patch0:         %{name}-%{version}.patch
Patch1:         %{name}-%{version}-sysfs.patch
ExcludeArch:    ppc ppc64

%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

BuildRequires:  gcc
Source44: import.info
%description    
libacpi is a general purpose shared library for programs gathering 
ACPI data on Linux. Features: Thermal zones support, Battery support, 
Fan support, AC support

Note: This is no portable code, it will only run on i386/x86_64 Linux systems.

%package        devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q
%patch0 -p1
%patch1 -p1
sed -i "s|CFLAGS += .*|CFLAGS += -fPIC $RPM_OPT_FLAGS|;s&usr/local&usr&" config.mk
sed -i "s&\${PREFIX}/share/doc/%{name}&%{_docdir}/%{name}&g" Makefile


%build
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT LIBDIR=%_libdir
chmod +x $RPM_BUILD_ROOT%{_libdir}/%{name}.so.*
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'





%files
%{_mandir}/man3/*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/AUTHORS
%doc %{_docdir}/%{name}/CHANGES
%doc %{_docdir}/%{name}/README
%doc %{_docdir}/%{name}/LICENSE
%{_libdir}/*.so.*

%files devel
%dir %{_docdir}/%{name}/doc
%doc %{_docdir}/%{name}/doc/*
%{_bindir}/test-libacpi
%{_includedir}/*
%{_libdir}/*.so


%changelog
