# use no more than system_memory/2000 build procs (see https://bugzilla.altlinux.org/show_bug.cgi?id=35112)
%_tune_parallel_build_by_procsize 2000

%def_with python

Name: ledger
Version: 3.3.2
Release: alt1.2

Summary: Ledger is a highly flexible, double-entry accounting system

License: BSD-3-Clause
Group: Office
Url: http://www.ledger-cli.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/ledger/ledger/archive/v%version.tar.gz
Source: %name-%version.tar

Patch: 69e6b89cf8d2820d28174e7ffaea1c59a0f84d3f.patch
Patch1: ledger-upstream-fix-build-with-boost-1.85.0.patch
Patch2: ledger-upstream-fix-build-with-boost-1.86.0.patch

Requires: libledger = %EVR

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-intro

BuildRequires: cmake gcc-c++
BuildRequires: boost-filesystem-devel
%if_with python
BuildRequires: boost-python3-devel
%endif
BuildRequires: libedit-devel libicu-devel libmpfr-devel libutfcpp-devel libssl-devel

%description
Ledger is an accounting program which is invoked from the command-line
using a textual ledger file.  To start using Ledger, you will need to
create such a file containing your financial transactions.
See the documentation (ledger.pdf, or ledger.info) for full documentation
on creating a ledger file and using Ledger to generate reports.

A sample has been provided in the file "sample.dat":
$ ledger -f %_docdir/%name-%version/sample.dat reg

%package -n libledger
Summary: Libraries for ledger accounting system
Group: System/Libraries

%description -n libledger
Ledger is an accounting program which is invoked from the command-line
using a textual ledger file.  To start using Ledger, you will need to
create such a file containing your financial transactions.  A sample
has been provided in the file "sample.dat".  See the documentation
(ledger.pdf, or ledger.info) for full documentation on creating a
ledger file and using Ledger to generate reports.

This package contains libraries for ledger to use.

%package -n libledger-devel
Summary: Development files for ledger accounting system
Group: Development/C
Requires: libledger = %version-%release

%description -n libledger-devel
Ledger is an accounting program which is invoked from the command-line
using a textual ledger file.  To start using Ledger, you will need to
create such a file containing your financial transactions.  A sample
has been provided in the file "sample.dat".  See the documentation
(ledger.pdf, or ledger.info) for full documentation on creating a
ledger file and using Ledger to generate reports.

This package contains files needed for developing programs using
ledger facilities.

%package -n python3-module-%name
Summary: Python bindings for ledger
Group: Development/Python3
Requires: libledger = %EVR

%description -n python3-module-%name
Ledger is an accounting program which is invoked from the command-line
using a textual ledger file.  To start using Ledger, you will need to
create such a file containing your financial transactions.  A sample
has been provided in the file "sample.dat".  See the documentation
(ledger.pdf, or ledger.info) for full documentation on creating a
ledger file and using Ledger to generate reports.

This package contains python bindings for some of ledger
functionality.

%package -n emacs-ledger
Summary: Emacs mode for ledger accounting system
Group: Editors
Requires: ledger = %EVR

%description -n emacs-ledger
Ledger is an accounting program which is invoked from the command-line
using a textual ledger file.  To start using Ledger, you will need to
create such a file containing your financial transactions.  A sample
has been provided in the file "sample.dat".  See the documentation
(ledger.pdf, or ledger.info) for full documentation on creating a
ledger file and using Ledger to generate reports.

This package contains emacs libraries to ease use of ledger.

%prep
%setup
#patch -p1
%patch1 -p1
%patch2 -p1

%build
%cmake -DUSE_PYTHON=yes
# 15.08.2015: disabled due ledger3.info install bug
# -DBUILD_DOCS=yes
%cmake_build

%install
%cmake_install

%files
%doc LICENSE.md README.md
%doc test/input/sample.dat
%_bindir/%name
%_man1dir/*

%files -n libledger
%_libdir/libledger.so.3

%files -n libledger-devel
%_includedir/%name/
%_libdir/libledger.so

%if_with python
%files -n python3-module-ledger
%python3_sitelibdir/*
%endif

#%files -n emacs-ledger
#%_emacslispdir/*

%changelog
