%define _unpackaged_files_terminate_build 1

Name: lact
Version: 0.8.2
Release: alt1

Summary: Linux GPU Control Application
License: MIT
Group: Monitoring

Url: https://github.com/ilya-zlobintsev/LACT
Vcs: https://github.com/ilya-zlobintsev/LACT
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64 aarch64 ppc64le loongarch64

# Source-url: https://github.com/ilya-zlobintsev/LACT/archive/v%version/LACT-%version.tar.gz
Source0: LACT-%version.tar
# cargo vendor
Source1: crates.tar

Source2: config

Patch1: lact-0.7.3-alt-loongarch-define.patch

BuildRequires(pre): clang-devel

BuildRequires: libgtk4-devel
BuildRequires: llvm-devel
BuildRequires: ocl-icd-devel
BuildRequires: rust-cargo

%description
This application allows you to control your AMD, Nvidia or Intel GPU on a Linux system.

Current features:

   - Viewing information about the GPU
   - Power and thermals monitoring, power limit configuration
   - Fan curve control (AMD and Nvidia)
   - Overclocking (GPU/VRAM clockspeed and voltage)
   - Power states configuration (AMD only)

All of the functionality works regardless of the desktop session (there is no dependency on X11 extensions).

%prep
%setup -n LACT-%version
tar xf %SOURCE1
%__mkdir_p cargo
%__cp %SOURCE2 cargo

# allow patching vendored rust code
sed -i -e 's/"files":{[^}]*}/"files":{}/' \
     ./vendor/libc/.cargo-checksum.json

%autopatch -p1

%build
export CARGO_HOME=${PWD}/cargo
cargo build --release --offline

%install
DESTDIR=%buildroot PREFIX=%prefix make install

%post
%post_systemd %{name}d.service

%preun
%preun_systemd %{name}d.service

%files
%doc API.md LICENSE README.md
%_bindir/%name
%_desktopdir/io.github.ilya_zlobintsev.LACT.desktop
%_pixmapsdir/io.github.ilya_zlobintsev.LACT.png
%_iconsdir/hicolor/scalable/apps/io.github.ilya_zlobintsev.LACT.svg
%_datadir/metainfo/io.github.ilya_zlobintsev.LACT.metainfo.xml
%_unitdir/%{name}d.service

%changelog
