%define _unpackaged_files_terminate_build 1
%define soversion 2.12.0
Name: labplot
Version: 2.12.1
Release: alt1
Summary: Function and Data Plotter
License: GPL-2.0+
Group: Sciences/Mathematics
Url: https://labplot.kde.org/
%K6init no_altplace

Conflicts: labplot1.6
Requires: ImageMagick-tools gsl pstoedit

VCS: https://invent.kde.org/education/labplot.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-kf6
BuildRequires: cmake gcc-c++ extra-cmake-modules
BuildRequires: qt6-base-devel qt6-svg-devel
BuildRequires: qt6-declarative-devel
BuildRequires: libfftw3-devel
BuildRequires: liblz4-devel
BuildRequires: libcerf-devel
BuildRequires: libvulkan-devel
BuildRequires: libpoppler-qt6-devel
BuildRequires: eigen3
BuildRequires: kf6-kparts-devel
BuildRequires: kf6-purpose-devel
BuildRequires: kf6-karchive-devel kf6-kcompletion-devel kf6-kconfig-devel kf6-kconfigwidgets-devel
BuildRequires: kf6-kcoreaddons-devel kf6-kdoctools-devel kf6-ki18n-devel kf6-kiconthemes-devel
BuildRequires: kf6-kio-devel kf6-knewstuff-devel kf6-ktextwidgets-devel
BuildRequires: kf6-kwidgetsaddons-devel kf6-kxmlgui-devel
BuildRequires: libXScrnSaver-devel libXau-devel libXcomposite-devel
BuildRequires: libXdamage-devel libXdmcp-devel libXpm-devel libXt-devel
BuildRequires: libXtst-devel libXv-devel libXxf86misc-devel
BuildRequires: libgsl-devel libhdf5-devel libnetcdf-devel
BuildRequires: libxkbfile-devel xorg-xf86vidmodeproto-devel
BuildRequires: qt6-serialport-devel
BuildRequires: kf6-syntax-highlighting-devel

%description
This is a program for plotting of functions and data manipulation.

A versatile spreadsheet for data import and editing was added.
Also a better 3 dimensional plot with rotation and colormaps is available.
Newly supported are data set operations and image manipulations. One can now
import over 80 different images formats and export directly to ps, eps or pdf.
The plots now use double buffering and LabPlot supports scripting using QSA.

%package -n liblabplot-devel
Summary: Development files for labplot
Group: Development/KDE and QT

%description -n liblabplot-devel
This package contains the LabPlot Software Development Kit.

%package -n liblabplot%soversion
Summary: Library for LabPlot - data analysis and visualization
Group: Sciences/Mathematics

%description -n liblabplot%soversion
LabPlot is a free software data analysis and visualization tool.
This package provides the shared library for LabPlot.

%prep
%setup

%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%K6build \
    -DQT_VERSION_MAJOR=6 \
    -DENABLE_READSTAT:BOOL=OFF \
    -DENABLE_VECTOR_BLF:BOOL=OFF \
    -DENABLE_REPRODUCIBLE:BOOL=ON \
    #

%install
%K6install
%find_lang %name --with-kde --all-name

%files -f %name.lang
%doc AUTHORS README.md LICENSES/* ChangeLog
%_K6bin/*
%_datadir/%{name}/
%_K6xdgapp/*
%_K6icon/hicolor/*/apps/*
%_K6xdgmime/%{name}.xml
%_datadir/metainfo/*.xml

%files -n liblabplot%soversion
%_libdir/liblabplot.so.%soversion

%files -n liblabplot-devel
%_includedir/labplot
%_libdir/cmake/labplot
%_K6link/liblabplot.so

%changelog
