Name: ktoblzcheck
Version: 1.53
Release: alt1

Summary: A library to check account numbers and bank codes of German banks

Packager: Andrey Cherepanov <cas@altlinux.org>

License: LGPL v2+
Group: System/Libraries
Url: http://ktoblzcheck.sourceforge.net/

Source: http://prdownloads.sf.net/ktoblzcheck/%name-%version.tar.gz
Source1: %name.watch

BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: libstdc++-devel
BuildRequires: lynx
BuildRequires: python-devel
BuildRequires: python-modules-encodings
BuildRequires: recode

%description
KtoBLZCheck is a library to check account numbers and bank codes of
German banks.

Both a library for other programs as well as a short command-line tool
is available. It is possible to check pairs of account numbers and
bank codes (BLZ) of German banks, and to map bank codes (BLZ) to the
clear-text name and location of the bank.

%package devel
Summary: Header files for KtoBLZCheck library
Group: Development/Other
Requires: %name = %version-%release

%description devel
Header files for KtoBLZCheck library.

%package -n python-module-ktoblzcheck
Summary: Python binding for KtoBLZCheck library
Group: Development/Python
Requires: %name = %version-%release

%description -n python-module-ktoblzcheck
Python binding for KtoBLZCheck library.

%prep
%setup -q

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

%files
%doc AUTHORS ChangeLog NEWS README.md
%_bindir/ktoblzcheck
%_bindir/ibanchk
%_libdir/libktoblzcheck.so.*
%dir %_datadir/%name/
%_datadir/%name/*.txt
%_man1dir/ktoblzcheck.1*
%_man1dir/ibanchk.1*

%files devel
%_libdir/libktoblzcheck.so
%_includedir/*.h
%_libdir/cmake/*
%_pkgconfigdir/ktoblzcheck.pc

%files -n python-module-ktoblzcheck
%python_sitelibdir/%name.*

%changelog
