%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%ifver_gteq %ubt_id M110
%define qtver 6
%define kfver 6
%else
%define qtver 5
%define kfver 5
%endif

Name: krb5-ticket-watcher
Version: 1.0.3
Release: alt30

Group: System/X11
Summary: A Tray Applet for Watching, Renewing, and Reinitializing Kerberos Tickets
Url: http://sourceforge.net/projects/krb5ticketwatch
License: GPL-2.0-or-later

Source: %name-%version.tar
Source10: ru.po

Patch1: 0001-made-default-realm-the-first-one-in-list.patch
Patch2: krb5-ticket-watcher-1.0-alt-date-fix.patch
Patch3: krb5-ticket-watcher-1.0.3-alt-fix-includes.patch
Patch4: krb5-ticket-watcher-1.0.3-alt-fix-desktop-category.patch
#
Patch6: alt-tray-icon.patch
Patch7: alt-wait-for-tray.patch
Patch8: alt-force-kinit.patch
Patch9: alt-password-dialog-ontop.patch
#
Patch11: fix-deprecated-krb5-api-meth.patch
Patch12: alt-crash-1.patch
Patch13: alt-ignore-localhost-ip-as-def-realm.patch
Patch14: alt-no-message-on-automatic-reniew.patch
Patch15: alt-rework-password-change.patch

BuildRequires(pre): rpm-build-xdg rpm-build-ubt rpm-macros-ifver
BuildRequires: rpm-build-kf%qtver
BuildRequires: desktop-file-utils
BuildRequires: libkrb5-devel libkeyutils-devel
BuildRequires: cmake libcom_err-devel qt%qtver-base-devel qt%qtver-tools kf%kfver-kwidgetsaddons-devel

%description
A tray applet for watching, renewing, and reinitializing Kerberos
tickets.

%prep
%setup
%patch1 -p2
%patch2 -p1
%patch3 -p2
%patch4 -p2
#
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
#
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
cat %SOURCE10 > po/ru.po

%build
%if %qtver == 6
%K6init no_altplace
%define Kbuild %K6build
%define Kinstall %K6install
%else
%K5init no_altplace
%define Kbuild %K5build
%define Kinstall %K5install
%endif
%add_optflags -pedantic -DDEBUG -I%_includedir/krb5
%ifarch %e2k
%add_optflags -std=c++11
%endif
%Kbuild \
    -DQT_MAJOR_VERSION=%qtver \
    #

%install
%Kinstall
desktop-file-install --dir %buildroot%_desktopdir \
	%buildroot%_desktopdir/krb5-ticket-watcher.desktop
desktop-file-install --dir %buildroot/%_xdgconfigdir/autostart \
	%buildroot/%_desktopdir/krb5-ticket-watcher.desktop
%find_lang --all-name %name

%files -f %name.lang
%_bindir/krb5-ticket-watcher
%_pixmapsdir/krb5-ticket-watcher.png
%_desktopdir/krb5-ticket-watcher.desktop
%_xdgconfigdir/autostart/krb5-ticket-watcher.desktop
%doc COPYING Changes News TODO

%changelog
