%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: kmod
Version: 34.2
Release: alt1
Summary: Linux kernel module management utilities

Group: System/Kernel and hardware
License: GPL-2.0-or-later AND LGPL-2.1-or-later
Url: http://modules.wiki.kernel.org/
ExclusiveOS: Linux
Requires: lib%name = %EVR

Source0: %name-%version.tar

BuildRequires: bash-completion
BuildRequires: glibc-devel-static
BuildRequires: liblzma-devel
BuildRequires: libssl-devel
BuildRequires: libzstd-devel
BuildRequires: zlib-devel
BuildRequires: scdoc
# for tests
BuildRequires: kernel-headers-modules-latest

Provides: module-init-tools = 3.17-alt1
Obsoletes: module-init-tools
Conflicts: module-init-tools-compat
Conflicts: filesystem < 3
Provides: /bin/kmod /bin/lsmod
Provides: /sbin/depmod /sbin/insmod /sbin/lsmod /sbin/modinfo /sbin/modprobe /sbin/rmmod
Obsoletes: bash-completion-%name

%description
The kmod package provides various programs needed for automatic
loading and unloading of modules under 2.6, 3.x, and later kernels, as well
as other module management programs. Device drivers and filesystems are two
examples of loaded and unloaded modules.

%package -n lib%name
Summary: Libraries to handle kernel module loading and unloading
License: LGPL-2.1-or-later
Group: System/Kernel and hardware
Provides: %name-libs = %EVR

%description -n lib%name
The kmod-libs package provides runtime libraries for any application that
wishes to load or unload Linux kernel modules from the running system.

%package -n lib%name-devel
Summary: Header files for kmod development
Group: Development/C
License: LGPL-2.1-or-later
Requires: lib%name = %EVR
Provides: %name-devel = %EVR

%description -n lib%name-devel
The libkmod-devel package provides header files used for development of
applications that wish to load or unload Linux kernel modules.

%prep
%setup

%build
touch libkmod/docs/gtk-doc.make
%autoreconf

%configure \
    --disable-static \
    --with-openssl \
    --with-zlib \
    --with-xz \
    --with-zstd \
    #
%make_build

%install
%make_install DESTDIR=%buildroot install
rm -rf %buildroot/%_libdir/*.la

# New configuration files we ship (if any) should go into /usr/lib/modprobe.d
# in order to allow the local sysadmin to customize /etc/modprobe.d
mkdir -p %buildroot/{%_sysconfdir,%prefix/lib}/modprobe.d
mkdir -p %buildroot/{%_sysconfdir,%prefix/lib}/depmod.d

# Add blacklists from module-init-tools
find rpm/modprobe.d -maxdepth 1 -type f -name '*.conf' -print0 |
    xargs -r0 install -m644 -p -t %buildroot%_modprobedir/ --

%ifarch %ix86 x86_64
install -m644 -p rpm/modprobe.d/arch/i386.conf %buildroot%_modprobedir/arch.conf
%endif

# Make compatibility symlinks
for n in lsmod; do
    t=$(relative %_bindir/kmod %_bindir/$n)
    ln -s "$t" "%buildroot%_bindir/$n"
done

# cleanup non-root access utils
rm -f %buildroot%_bindir/{depmod,insmod,modinfo,modprobe,rmmod}

%check
%make check V=1 KDIR=/lib/modules/*/build

%files
%doc NEWS README.md COPYING
%dir %_sysconfdir/depmod.d
%dir %_sysconfdir/modprobe.d
%dir %_prefix/lib/depmod.d
%dir %_modprobedir
%_modprobedir/*.conf
%_bindir/kmod
%_bindir/lsmod
%_sbindir/depmod
%_sbindir/insmod
%_sbindir/lsmod
%_sbindir/modinfo
%_sbindir/modprobe
%_sbindir/rmmod
%_man5dir/*
%_man8dir/*
%_datadir/bash-completion/completions/*
%_datadir/fish/vendor_functions.d/*
%_datadir/zsh/site-functions/*

%files -n lib%name
%_libdir/libkmod.so.*

%files -n lib%name-devel
%_includedir/libkmod.h
%_pkgconfigdir/libkmod.pc
%_libdir/libkmod.so
%_datadir/pkgconfig/%name.pc

%changelog
