%define rname kxmlgui

Name: kf6-%rname
Version: 6.19.0
Release: alt1
%K6init altplace

Group: System/Libraries
Summary: KDE Frameworks 6 managing menu and toolbar actions
Url: http://www.kde.org
License: LGPL-2.0-or-later

Source: %rname-%version.tar

BuildRequires(pre): rpm-build-kf6
BuildRequires: extra-cmake-modules qt6-tools-devel qt6-declarative-devel
BuildRequires: kf6-kauth-devel kf6-kcodecs-devel kf6-kcompletion-devel
BuildRequires: kf6-kconfig-devel kf6-kconfigwidgets-devel kf6-kcoreaddons-devel kf6-kdbusaddons-devel
BuildRequires: kf6-kglobalaccel-devel kf6-kguiaddons-devel kf6-ki18n-devel
BuildRequires: kf6-kiconthemes-devel kf6-kitemviews-devel kf6-kservice-devel
BuildRequires: kf6-ktextwidgets-devel kf6-kwidgetsaddons-devel kf6-kwindowsystem-devel
BuildRequires: kf6-kcolorscheme-devel

%description
KXMLGUI provides a framework for managing menu and toolbar actions in an
abstract way. The actions are configured through a XML description and hooks
in the application code. The framework supports merging of multiple
description for example for integrating actions from plugins.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kde-common
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: kf6-attica-devel kf6-kconfig-devel kf6-kconfigwidgets-devel kf6-kglobalaccel-devel
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf6xmlgui
Group: System/Libraries
Summary: KF6 library
Requires: %name-common = %version-%release
%description -n libkf6xmlgui
KF6 library


%prep
%setup -n %rname-%version

%build
%K6build \
    -DBUILD_PYTHON_BINDINGS:BOOL=OFF \
    #

%install
%K6install
%find_lang %name --all-name
%K6find_qtlang %name --all-name

%files common -f %name.lang
%doc LICENSES/* README.md
%_datadir/qlogging-categories6/*.*categories

%files devel
%_K6inc/KXmlGui/
%_K6link/lib*.so
%_K6lib/cmake/KF6XmlGui/
%_K6plug/designer/*.so

%files -n libkf6xmlgui
%_K6lib/libKF6XmlGui.so.*


%changelog
