%define rname kwallet

Name: kf5-%rname
Version: 5.116.0
Release: alt3
%K5init

Group: System/Libraries
Summary: KDE Frameworks 5 safe desktop-wide storage for passwords
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Requires(post,preun): alternatives >= 0.2

Source: %rname-%version.tar
Source1: kwalletd5.po
Patch2: alt-def-blowfish.patch
Patch3: alt-create-wallet.patch
Patch4: alt-fix-wallet-format.patch
Patch5: alt-org-freedesktop-secrets-service.patch

# Automatically added by buildreq on Fri Feb 13 2015 (-bi)
# optimized out: cmake cmake-modules elfutils libEGL-devel libGL-devel libcloog-isl4 libgpg-error libgpg-error-devel libqt5-core libqt5-dbus libqt5-gui libqt5-svg libqt5-test libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libxcbutil-keysyms python-base ruby ruby-stdlibs
#BuildRequires: extra-cmake-modules gcc-c++ glibc-devel-static kf5-kauth-devel kf5-kcodecs-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kdbusaddons-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kitemviews-devel kf5-knotifications-devel kf5-kservice-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel libgcrypt-devel libgpgme-devel python-module-google qt5-base-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
BuildRequires: extra-cmake-modules gcc-c++ glibc-devel qt5-base-devel
BuildRequires: libgcrypt-devel libgpgme-devel libassuan-devel
BuildRequires: boost-devel
BuildRequires: kf5-kauth-devel kf5-kcodecs-devel kf5-kconfig-devel kf5-kconfigwidgets-devel
BuildRequires: kf5-kcoreaddons-devel kf5-kdbusaddons-devel kf5-kguiaddons-devel kf5-ki18n-devel
BuildRequires: kf5-kiconthemes-devel kf5-kitemviews-devel kf5-knotifications-devel
BuildRequires: kf5-kservice-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel
BuildRequires: kf5-kdoctools-devel kf5-kdoctools
BuildRequires: libqca-qt5-devel
# For secrets API tests
BuildRequires: qca-qt5-ossl

%description
This framework contains two main components:
* Interface to KWallet, the safe desktop-wide storage for passwords on KDE work spaces.
* The kwalletd used to safely store the passwords on KDE work spaces.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5wallet
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5wallet
KF5 library

%package -n libkwalletbackend5
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkwalletbackend5
KF5 library


%prep
%setup -n %rname-%version
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

msgcat --use-first po/ru/kwalletd5.po %SOURCE1 > po/ru/kwalletd5.po.tmp
cat po/ru/kwalletd5.po.tmp >po/ru/kwalletd5.po
rm -f po/ru/kwalletd5.po.tmp

%build
%K5cmake -DBUILD_TESTING=ON
%K5make

%check
LD_LIBRARY_PATH=BUILD/bin BUILD/bin/fdo_secrets_test

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name

install -d %buildroot/%_sysconfdir/alternatives/packages.d/
> %buildroot/%_sysconfdir/alternatives/packages.d/%name
# install alternative
if [ "%_K5dbus_srv" == "%_datadir/dbus-1/services" ] ; then
    mkdir -p %buildroot/%_datadir/kf5/dbus-1/services/
    mv %buildroot/%_K5dbus_srv/org.freedesktop.secrets.service %buildroot/%_datadir/kf5/dbus-1/services/
    cat > %buildroot/%_sysconfdir/alternatives/packages.d/%name <<__EOF__
%_K5dbus_srv/org.freedesktop.secrets.service %_datadir/dbus-1/services/org.kde.kwalletd5.service %version
__EOF__
    mv %buildroot/%_K5bin/kwallet-query %buildroot/%_K5bin/kwallet-query-5
    cat >> %buildroot/%_sysconfdir/alternatives/packages.d/%name <<__EOF__
%_bindir/kwallet-query %_K5bin/kwallet-query-5 %version
__EOF__
fi

%files common -f %name.lang
%doc LICENSES/* README.md
%_datadir/qlogging-categories5/*.*categories

%files
%config /%_sysconfdir/alternatives/packages.d/%name
%_bindir/kwalletd5
%_K5bin/kwalletd5
%_K5bin/kwallet-query*
%_K5xdgapp/*.desktop
%_K5notif/*.notifyrc
%_K5srv/*.desktop
%_datadir/dbus-1/services/org.kde.kwalletd5.service
%_datadir/kf5/dbus-1/services/org.freedesktop.secrets.service

%files devel
#%_K5inc/kwallet_version.h
%_K5inc/KWallet/
%_K5link/lib*.so
%_K5lib/cmake/KF5Wallet
%_K5archdata/mkspecs/modules/qt_KWallet.pri
%_K5dbus_iface/*.xml

%files -n libkf5wallet
%_K5lib/libKF5Wallet.so.*
%files -n libkwalletbackend5
%_K5lib/libkwalletbackend5.so.*

%changelog
