%define rname kded
%ifndef _unitdir_user
%define _unitdir_user %prefix/lib/systemd/user
%endif
%define service_name plasma-kded

Name: kf5-%rname
Version: 5.116.0
Release: alt1
%K5init

Group: System/Libraries
Summary: KDE Frameworks 5 central daemon of KDE work spaces
Url: http://www.kde.org
License: LGPL-2.0 or GPL-2.0

Requires: %name-common = %version-%release

Source: %rname-%version.tar

# Automatically added by buildreq on Tue Feb 17 2015 (-bi)
# optimized out: cmake cmake-modules docbook-dtds elfutils kf5-kdoctools-devel libEGL-devel libGL-devel libcloog-isl4 libgpg-error libqt5-core libqt5-dbus libqt5-gui libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libxcbutil-keysyms python-base ruby ruby-stdlibs xml-common xml-utils
#BuildRequires: docbook-style-xsl extra-cmake-modules gcc-c++ kf5-karchive-devel kf5-kconfig-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdoctools kf5-kdoctools-devel kf5-ki18n-devel kf5-kinit-devel kf5-kservice-devel kf5-kwindowsystem-devel python-module-google qt5-base-devel rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
BuildRequires: libsystemd-devel
BuildRequires: docbook-style-xsl extra-cmake-modules gcc-c++ qt5-base-devel
BuildRequires: kf5-karchive-devel kf5-kconfig-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel
BuildRequires: kf5-kdoctools kf5-kdoctools-devel
BuildRequires: kf5-ki18n-devel kf5-kinit-devel kf5-kservice-devel kf5-kwindowsystem-devel

%description
KDED stands for KDE Daemon which isn't very descriptive.
KDED runs in the background and performs a number of small tasks.
Some of these tasks are built in, others are started on demand.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %version-%release
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n libkf5ded
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n libkf5ded
KF5 library

%prep
%setup -n %rname-%version

%build
%K5build \
    #
#    -DSYSTEMD_USER_UNIT_INSTALL_DIR=%_unitdir_user \

%install
%K5install
%find_lang %name --all-name
%K5find_qtlang %name --all-name

#mkdir -p -m 0755 %buildroot/%_presetdir
#cat >%buildroot/%_presetdir/33-%name.preset <<__EOF__
## Need to be enabled by default
#enable %service_name.service
#__EOF__


%files common -f %name.lang
%doc LICENSES/* README.md
%_datadir/qlogging-categories5/*.*categories

%files
%_bindir/kded5
%_K5bin/kded5
#%_K5lib/libkdeinit5_*.so
%_K5xdgapp/*.desktop
%_K5srvtyp/*.desktop
#%_K5dbus_srv/*.service
%_datadir/dbus-1/services/*.service
%_unitdir_user/%service_name.service
#%_presetdir/*-%name.preset

%files devel
#%_K5inc/kded_version.h
#%_K5inc/KDED/
#%_K5link/lib*.so
%_K5lib/cmake/KDED
#%_K5archdata/mkspecs/modules/qt_KDED.pri
%_K5dbus_iface/*.xml

#%files -n libkf5ded
#%_K5lib/libKF5DED.so.*

%changelog
