# -*- rpm-spec -*-
%define module_name	bcmwl
%define module_version  6.30.223.271
%define real_version	6.30.223.271
# for patched version
%define git 6adc981

#### MODULE SOURCES ####
Name: kernel-source-%module_name
Version: %module_version
Release: alt12.g%{git}
Provides: kernel-source-%module_name-%module_version
Summary: Linux %module_name Broadcom WiFi chipset series module sources
License: Proprietary
Group: Development/Kernel
Url: https://github.com/antoineco/broadcom-wl
Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

Source0: %name-%real_version.tar

ExclusiveArch: %ix86 x86_64
BuildPreReq: kernel-build-tools

%description
%module_name module sources for Linux kernel.

Patched for Linux >= 4.7

%package -n bcmwl-kernel-conf
Summary: bcmwl kernel module configuration
Group: System/Kernel and hardware
BuildArch: noarch

%description -n bcmwl-kernel-conf
bcmwl kernel module configuration.

%prep
%setup -c -q

%install
# blacklist several modules (see ALT bugs #26265, #26250)
mkdir -p %buildroot/%_sysconfdir/modprobe.d
cat > %buildroot/%_sysconfdir/modprobe.d/blacklist-bcm.conf << __EOF__
blacklist bcm43xx
blacklist ssb
blacklist b43
__EOF__
cat > %buildroot/%_sysconfdir/modprobe.d/blacklist-bcm2.conf << __EOF__
blacklist b44
blacklist b43legacy
blacklist bcma
blacklist brcmsmac
blacklist brcmfmac
blacklist bcma-pci-bridge
__EOF__

mkdir -p %kernel_srcdir
%ifarch %ix86
rm -f %name-%version/bcmwl/lib/wlc_hybrid.o_shipped
mv %name-%version/bcmwl/lib/wlc_hybrid.o_shipped.i386 %name-%version/bcmwl/lib/wlc_hybrid.o_shipped
%endif
tar jcf %kernel_srcdir/%name-%version.tar.bz2 %name-%version/bcmwl

%files
%attr(0644,root,root) %kernel_src/%name-%version.tar.bz2

%files -n bcmwl-kernel-conf
%config(noreplace) %_sysconfdir/modprobe.d/blacklist-bcm.conf
%config(noreplace) %_sysconfdir/modprobe.d/blacklist-bcm2.conf

%changelog
