%define _unpackaged_files_terminate_build 1

%define kernel_version		6.17

Name: kernel-source-%kernel_version
Version: 0
Release: alt1

Summary: Linux kernel %kernel_version sources
License: GPL-2.0-only
Group: Development/Kernel
Url: https://www.kernel.org
Vcs: https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git
Packager: Kernel Maintainers Team <kernel@packages.altlinux.org>

Source: %name.tar
Source1: .gear.tar

BuildArch: noarch
BuildRequires(pre): rpm-build-kernel
AutoReqProv: no

%{?!_without_check:%{?!_disable_check:
BuildRequires: gnupg
}}

%description
Kernel sources for Linux kernel %kernel_version tarred in
  %kernel_src/kernel-source-%kernel_version.tar
Its purpose is to build dependent packages from it minimizing
their src.rpm size.

%prep
%setup -c

%install
mkdir -p %buildroot%kernel_src
tar --owner=root --group=root --mode=u+w,go-w,go+rX -cf \
	%buildroot%kernel_src/%name.tar \
	%name

%check
cd %name
set -u

# Verify that we packaged correct version.
EVER=%kernel_version
AVER=$(MAKEFLAGS=-s make kernelversion)
AVER=${AVER%%.0} # It's 'x.y.z', thus strip one trailing '.0'
grep -Fx "$EVER" <<< "$AVER"

# Verify upstream tag. Due to `tar: v@version@:.` gear rule we package
# appropriate upstream tag into `.gear/tags/`.
rm -rf .gear
tar xvf %SOURCE1
pushd .gear
gpg -q --import upstream-signing-key.asc
gpg --list-keys --fingerprint
TAG=( $(grep -P " v\Q$EVER\E\$" tags/list) )
csplit --prefix=tag -- "tags/$TAG" '/^-----BEGIN PGP SIGNATURE-----$/'
gpg --verify tag01 tag00

%files
%kernel_src/%name.tar

%changelog
