%define original_kernel_version	5.9
%define kernel_version		5.9
%define patch_level		%nil

%define kernel_fullversion	%kernel_version%patch_level

# Numeric extra version scheme developed by Alexander Bokovoy:
# 0.0.X -- preX
# 0.X.0 -- rcX, testX
# 1.0.0 -- release
%define patch_level_numeric     1.0.0

Name: kernel-source-%kernel_version
Version: %patch_level_numeric
Release: alt1

Summary: Linux kernel %kernel_fullversion sources
License: GPL-2.0-only
Group: Development/Kernel
Packager: Kernel Maintainers Team <kernel@packages.altlinux.org>

Source: linux-%kernel_fullversion.tar

BuildArch: noarch
BuildRequires(pre): rpm-build-kernel
AutoReqProv: no

%description
Kernel sources for Linux kernel %kernel_fullversion.

%prep
%setup -c
mv linux-%kernel_fullversion kernel-source-%kernel_version
cd kernel-source-%kernel_version

%install
mkdir -p %kernel_srcdir
tar --owner=root --group=root --mode=u+w,go-w,go+rX -cf \
	%kernel_srcdir/kernel-source-%kernel_version.tar \
	kernel-source-%kernel_version

%files
%kernel_src/kernel-source-%kernel_version.tar

%changelog
