%define module_name	virtualbox
%define module_version	7.2.4

%define module_release	alt1

%define drv_module_name	vboxdrv
%define pci_module_name	vboxpci
%define net_module_name	vboxnetflt
%define net_module_adaptor_name	vboxnetadp

%define flavour		6.12
%define karch x86_64
BuildRequires(pre): rpm-build-kernel >= 0.100-alt1
BuildRequires(pre): kernel-headers-modules-6.12

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/misc

%def_without vboxpci

Summary: VirtualBox modules
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: GPLv2
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
Url: http://www.virtualbox.org/

Patch0: vboxcommon-5.4.patch

BuildPreReq: gcc-c++
BuildRequires: perl
BuildRequires: rpm >= 4.0.2-75
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%drv_module_name = %module_version
%if_with vboxpci
BuildRequires: kernel-source-%pci_module_name = %module_version
%endif
BuildRequires: kernel-source-%net_module_name = %module_version
BuildRequires: kernel-source-%net_module_adaptor_name = %module_version

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

#PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
%requires_kimage
ExclusiveArch: %karch

Requires: %module_name-common

%description
This package contains VirtualBox modules (vboxdrv) that are needed
for VirtualBox to run. Note that you have to compile these modules on the
system with your VirtualBox version installed or you will have to specify
your VirtualBox version as `version' parameter when loading these modules
or in your /etc/modules.conf file.

%prep
%setup -T -c -n kernel-source-%module_name-%module_version
tar jxvf %kernel_src/kernel-source-%drv_module_name-%module_version.tar.bz2
%if_with vboxpci
tar jxvf %kernel_src/kernel-source-%pci_module_name-%module_version.tar.bz2
%endif
tar jxvf %kernel_src/kernel-source-%net_module_name-%module_version.tar.bz2
tar jxvf %kernel_src/kernel-source-%net_module_adaptor_name-%module_version.tar.bz2

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make -C kernel-source-%drv_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/ KERN_VER=%kversion
%if_with vboxpci
%make -C kernel-source-%pci_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/ KERN_VER=%kversion \
    KBUILD_EXTRA_SYMBOLS=%_builddir/kernel-source-%module_name-%module_version/kernel-source-%drv_module_name-%module_version/Module.symvers
%endif
%make -C kernel-source-%net_module_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/ KERN_VER=%kversion \
    KBUILD_EXTRA_SYMBOLS=%_builddir/kernel-source-%module_name-%module_version/kernel-source-%drv_module_name-%module_version/Module.symvers
%make -C kernel-source-%net_module_adaptor_name-%module_version \
    KERN_DIR=%_usrsrc/linux-%kversion-%flavour/ KERN_VER=%kversion \
    KBUILD_EXTRA_SYMBOLS=%_builddir/kernel-source-%module_name-%module_version/kernel-source-%drv_module_name-%module_version/Module.symvers

%install
mkdir -p %buildroot/%module_dir
install -pD -m644 kernel-source-%drv_module_name-%module_version/vboxdrv.ko \
    %buildroot%module_dir/
%if_with vboxpci
install -pD -m644 kernel-source-%pci_module_name-%module_version/vboxpci.ko \
    %buildroot%module_dir/
%endif
install -pD -m644 kernel-source-%net_module_name-%module_version/vboxnetflt.ko \
    %buildroot%module_dir/
install -pD -m644 kernel-source-%net_module_adaptor_name-%module_version/vboxnetadp.ko \
    %buildroot%module_dir/

%files
%defattr(644,root,root,755)
%module_dir

%changelog
