%define module_name             accel-ppp
%define module_version          1.13.0
%define module_release          alt3

%define flavour		6.12
%define karch	%ix86 x86_64 aarch64 ppc64le armh

BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-6.12

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/ipoe

Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease

Summary: Linux Kernel drivers support IPoE for accel-ppp
License: GPLv2
Group: System/Kernel and hardware
Url: http://sourceforge.net/projects/accel-ppp/

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
BuildRequires(pre): rpm-build-kernel cmake libpcre2-devel libssl-devel
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

Requires(pre): kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

%description
%module_name kernel driver support IPoE for accel-ppp

%prep
rm -rf %module_name-%module_version
tar -jxvf %kernel_src/%module_name-%module_version.tar.bz2
%setup -D -T -n %module_name-%module_version

%build
%cmake \
      -G 'Unix Makefiles' \
      -DKDIR=%_usrsrc/linux-%kversion-%flavour \
      -DBUILD_IPOE_DRIVER=TRUE \
      -DBUILD_VLAN_MON_DRIVER=TRUE \
      -B BUILD

make -C BUILD/drivers/ipoe
make -C BUILD/drivers/vlan_mon

%install
install -d %buildroot/%module_dir
install -m644 -D BUILD/drivers/ipoe/driver/ipoe.ko %buildroot/%module_dir/ipoe.ko
install -m644 -D BUILD/drivers/vlan_mon/driver/vlan_mon.ko %buildroot/%module_dir/vlan_mon.ko

%files
%module_dir

%changelog
