%define _unpackaged_files_terminate_build 1
%define _localstatedir %_var

%def_enable lvs
%def_enable vrrp
%def_enable bfd
%def_enable fwmark
%def_enable snmp
%def_enable dbus
%def_enable regex
%def_enable json
%def_enable routes
%def_enable libiptc
%def_enable libipset
%def_enable nftables
%def_enable libnl

Name: keepalived
Version: 2.3.4
Release: alt1

Summary: HA monitor built upon LVS, VRRP and services poller
License: GPL-2.0-or-later
Group: Networking/Other

Url: https://www.keepalived.org/
Vcs:https://github.com/acassen/keepalived.git
Source0: %name-%version.tar
Source1: %name.init
Patch0: keepalived-2.3.4-alt-update-systemd-unit.patch

BuildRequires: libpopt-devel libssl-devel
BuildRequires: pkgconfig(libkmod)
%{?_enable_libiptc:BuildRequires: pkgconfig(libiptc)}
%{?_enable_libipset:BuildRequires: pkgconfig(libipset)}
%{?_enable_nftables:BuildRequires: pkgconfig(libnftnl) pkgconfig(libmnl)}
%{?_enable_libnl:BuildRequires: pkgconfig(libnl-genl-3.0) pkgconfig(libnl-route-3.0) pkgconfig(libnl-3.0)}
%{?_enable_snmp:BuildRequires: libnet-snmp-devel}
%{?_enable_regex:BuildRequires: pkgconfig(libpcre2-8)}
%{?_enable_dbus:BuildRequires: pkgconfig(gio-2.0)}
BuildRequires: libmagic-devel
BuildRequires: systemd-devel

%description
The main goal of the keepalived project is to add a strong & robust keepalive
facility to the Linux Virtual Server project. This project is written in C with
multilayer TCP/IP stack checks. Keepalived implements a framework based on three
family checks : Layer3, Layer4 & Layer5/7. This framework gives the daemon the
ability of checking a LVS server pool states. When one of the server of the LVS
server pool is down, keepalived informs the linux kernel via a setsockopt call
to remove this server entrie from the LVS topology. In addition keepalived implements
an independent VRRPv2 stack to handle director failover. So in short keepalived is a
userspace daemon for LVS cluster nodes healthchecks and LVS directors failover.

%prep
%setup
%patch0 -p1
%ifarch %e2k
# lcc 1.23's edg frontend can only do numbers here (#4061)
sed -i 's,"O0",0,' lib/utils.c
%endif

%build
%autoreconf
%configure \
	--with-kernel-dir=/usr/include/linux-default \
	--enable-strict-config-checks \
	%{subst_enable lvs} \
	%{subst_enable vrrp} \
	%{subst_enable bfd} \
	%{subst_enable fwmark} \
	%{?_enable_snmp:--enable-snmp --enable-snmp-rfc} \
	%{subst_enable dbus} \
	%{subst_enable regex} \
	%{subst_enable json} \
	%{subst_enable routes} \
	%{subst_enable libipset} \
	%{subst_enable nftables} \
	%{subst_enable libnl} \
	--with-init=systemd \
	--enable-hardening \
	--with-systemdsystemunitdir=%_unitdir

%make_build STRIP=/bin/true

%install
%makeinstall_std
install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
rm -rf %buildroot%_sysconfdir/%name/samples
rm -rf %buildroot%_defaultdocdir/%name
mv %buildroot%_sysconfdir/%name/keepalived.conf.sample \
   %buildroot%_sysconfdir/%name/keepalived.conf

mkdir -p %buildroot%_datadir/mibs/%name
for f in %buildroot%_datadir/snmp/mibs/*.txt; do
    bn=$(basename "$f" .txt)
    mv "$f" "%buildroot%_datadir/mibs/%name/$bn"
done

%preun
%preun_service keepalived

%post
%post_service keepalived

%files
%_bindir/*
%_sbindir/*
%_man1dir/genhash.*
%_man5dir/keepalived.conf.*
%_man8dir/keepalived.*
%_initdir/%name
%_unitdir/%name.service
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%config(noreplace) %_sysconfdir/sysconfig/%name
%_datadir/mibs/%name
%if_enabled dbus
%config(noreplace) %_sysconfdir/dbus-1/system.d/org.keepalived.Vrrp1.conf
%_datadir/dbus-1/interfaces/*.xml
%endif

%doc AUTHOR ChangeLog README
%doc doc/keepalived.conf.SYNOPSIS
%doc doc/*-MIB*
%doc doc/*.txt
%doc doc/samples

%changelog
