%define rname krename

Name: kde5-%rname
Version: 5.0.2
Release: alt3
%K5init

Summary: A powerful batch renamer for KDE5
Group: File tools
License: GPL-2.0
Url: https://invent.kde.org/utilities/krename

Source: %rname-%version.tar
Source10: po-ru.po
# upstream
Patch1: exiv2-0.28.patch
Patch2: podofo-0.10.patch
#
Patch10: alt-startupinfo-labels-color.patch
Patch11: alt-cmake.patch
Patch12: alt-servicemenus.patch

BuildRequires(pre): rpm-build-kf5
BuildRequires: extra-cmake-modules gcc-c++
BuildRequires: kf5-kcompletion-devel kf5-kconfig-devel kf5-kcoreaddons-devel kf5-kcrash-devel
BuildRequires: kf5-ki18n-devel kf5-kiconthemes-devel kf5-kitemviews-devel kf5-kjobwidgets-devel
BuildRequires: kf5-kjs-devel kf5-kio-devel kf5-kservice-devel kf5-kwidgetsaddons-devel
BuildRequires: kf5-kxmlgui-devel
BuildRequires: libexiv2-devel
BuildRequires: fontconfig-devel libfreetype-devel libpodofo-devel
BuildRequires: libtag-devel
BuildRequires: qt5-base-devel

%description
Krename is a very powerful batch file renamer for KDE5 which can rename a list
of files based on a set of expressions. It can copy/move the files to another
directory or simply rename the input files. Krename supports many conversion
operations, including conversion of a filename to lowercase or to uppercase,
conversion of the first letter of every word to uppercase, adding numbers to
filenames, finding and replacing parts of the filename, and many more.
It can also change access and modification dates, permissions, and file ownership.

%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1
#
%patch10 -p1
%patch11 -p1
%patch12 -p1
#cat %SOURCE10 >po/ru/krename.po

%build
%K5build

%install
%K5install
%K5install_move data locale
%find_lang --with-kde %rname

%files -f %rname.lang
%_K5bin/%rname
%_K5xdgapp/*.desktop
%_K5icon/*/*/apps/*.*
%_K5data/kio/servicemenus/*.desktop
%_datadir/metainfo/*.xml

%changelog
